import React from 'react';
import { Dialog, DialogContent, DialogTitle, Stack, Typography } from '@mui/material';
import CloseButtonDialog from './CloseButtonDialog';

interface DialogUmumProps {
  isOpen: boolean;
  onClose: () => void;
  title?: string;
  onSubmit?: () => void;
  isLoadingButtonSubmit?: boolean;
  agreementText?: string;
  maxWidth?: 'xs' | 'sm' | 'md' | 'lg' | 'xl' | false;
  children?: React.ReactNode; // ✅ konten dinamis
  titleSx?: object;
}

const DialogUmum: React.FC<DialogUmumProps> = ({
  isOpen,
  onClose,
  title = 'Penandatangan',
  onSubmit = () => {},
  isLoadingButtonSubmit = false,
  agreementText = '',
  maxWidth = 'md',
  children,
  titleSx,
}) => (
  <Dialog
    fullWidth
    maxWidth={maxWidth}
    open={isOpen}
    onClose={onClose}
    aria-labelledby="dialog-rekap"
  >
    {/* Header */}
    <DialogTitle
      id="dialog-rekap"
      sx={{
        ...titleSx, // 👈 styling dari luar akan di-merge
      }}
    >
      <Stack direction="row" justifyContent="space-between" alignItems="center">
        <Typography textTransform="capitalize" fontWeight="bold" variant="inherit" color="initial">
          {title}
        </Typography>
        <CloseButtonDialog onClick={onClose} />
      </Stack>
    </DialogTitle>

    {/* ✅ konten dinamis */}
    <DialogContent sx={{ mb: 4 }}>{children}</DialogContent>
  </Dialog>
);

export default DialogUmum;
