export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataTableFakturPM = {
  id: number;
  fguangmuka: boolean;
  fgpelunasan: boolean;
  nomorfaktur: string;
  detailtransaksi: string;
  idketerangantambahan: string;
  keterangantambahan: string;
  masapajak: string;
  tahunpajak: string;
  refdoc: string;
  referensi: string;
  npwppenjual: string;
  namatokopenjual: string;
  npwppembeli: string;
  idlainpembeli: string;
  kdnegarapembeli: string;
  nikpasppembeli: string;
  namapembeli: string;
  tkupembeli: string;
  alamatpembeli: string | null;
  emailpembeli: string;
  totaldpp: string;
  totaldpplain: string;
  jumlahuangmuka: string;
  totalppn: string;
  totalppnbm: string;
  tempatpenandatangan: string | null;
  tanggalfaktur: string;
  npwpnikpenandatangan: string | null;
  passphrasepenandatangan: string | null;
  userid: string;
  kanal: string | null;
  approvalsign: string | null;
  idfaktur: string;
  tanggalapproval: string | null;
  statusfaktur: string;
  kodeapproval: string | null;
  created_by: string;
  updated_by: string;
  created_at: string;
  updated_at: string;
  testing1: string | null;
  testing2: string | null;
  detailkredittransaksi: string | null;
  tahunkreditpajak: string;
  masakreditpajak: string;
  statuspembeli: string;
  buyerstatus: string;
  internal_id: string;
  fgpengganti: string;
  fgbatal: string;
  errormsg: string | null;
  keterangan1: string;
  keterangan2: string;
  keterangan3: string;
  keterangan4: string;
  keterangan5: string;
  tkupenjual: string;
  uangmukadpp: string | null;
  uangmukadpplain: string | null;
  uangmukappn: string | null;
  uangmukappnbm: string | null;
  jumlahpelunasan: string | null;
};

export type TGetListDataTableFakturPMResult = TGetListDataTableFakturPM[];

export type TValidateFakturPMRequest = {
  id: number;
  nomorFaktur: string;
};

export interface TKonfirmasiFakturMasukan {
  konfirmasiPengkreditan: 'CREDITED' | 'UNCREDITED' | 'INVALID' | string;
  nomorFaktur: string;
  masaKredit: string; // "12"
  tahunKredit: string; // "2025"
  npwpPembeli: string;
  npwpPenjual: string;
}

export interface TUploadFakturPMRequest {
  fgPermintaan: number; // 2
  konfirmasiFakturMasukan: TKonfirmasiFakturMasukan;
}

// types/prepopulated.ts
export interface TRequestFakturMasukan {
  tahunPajak: string;
  masaPajak: string;
}

export interface TPrepopulatedPMRequest {
  fgPermintaan: number; // 1
  requestFakturMasukan: TRequestFakturMasukan;
}

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TPostUpload = {
  id: string;
};

export type TDeleteRequest = {
  id: string;
};

export type TCancelRequest = {
  id: string | number;
  revokeFlag?: boolean; // format: DDMMYYYY
  tglPembatalan?: string;
};

export type TCancelResponse = TBaseResponseAPI<{
  id: string | number;
  statusBatal?: string;
  message?: string;
}>;
