// import axios from 'axios';

// const BASE_URL = 'https://nodesandbox.pajakexpress.id:1837';

// // --- 1️⃣ Buat axios instance ---
// const api = axios.create({
//   baseURL: BASE_URL,
// });

// // --- 2️⃣ Tambahkan interceptor untuk inject header x-token ---
// api.interceptors.request.use((config) => {
//   // Ambil token dari localStorage (atau bisa kamu ubah dari Redux)
//   const token = localStorage.getItem('x-token');
//   if (token) {
//     config.headers['x-token'] = token;
//   }
//   return config;
// });

// // --- 3️⃣ Fungsi API (pakai instance api yang sudah siap) ---

// // Request ke API VSWP pakai NPWP
// export const getVswpByNpwp = async (npwp: string) => {
//   const payload = {
//     npwp,
//     tujuan: 'test aja', // selalu statis
//   };

//   const token = localStorage.getItem('x-token'); // atau ambil dari Redux jika perlu

//   const res = await api.post('/sandbox/vswp/npwp', payload, {
//     headers: {
//       'x-token': token || '', // header dikirim langsung di request ini
//     },
//   });

//   return res.data;
// };

// // Request ke API VSWP pakai NIK
// export const getVswpByNik = async (nik: string) => {
//   const payload = {
//     nik,
//     tujuan: 'test aja', // selalu statis
//   };

//   const token = localStorage.getItem('x-token');

//   const res = await api.post('/sandbox/vswp/nik', payload, {
//     headers: {
//       'x-token': token || '',
//     },
//   });

//   return res.data;
// };

// src/utils/vswpApi.ts
// import { TVswpResponse, TVswpData } from 'src/types/vswp';
import type { TVswpData, TVswpResponse } from '../types/types';
import dashboardClient from './dashboardClient';

const vswpApi = {
  getVswpByNpwp: async (npwp: string): Promise<TVswpData | null> => {
    const payload = { npwp, tujuan: 'test aja' };

    const {
      data: { status, data },
      // status: httpStatus,
    } = await dashboardClient.post<TVswpResponse>('/sandbox/vswp/npwp', payload);

    // ✅ status adalah dari body, bukan httpStatus
    if (status !== 1) {
      throw new Error('Gagal mengambil data VSWP (NPWP)');
    }

    return data;
  },

  getVswpByNik: async (nik: string): Promise<TVswpData | null> => {
    const payload = { nik, tujuan: 'test aja' };

    const {
      data: { status, data },
      // status: httpStatus,
    } = await dashboardClient.post<TVswpResponse>('/sandbox/vswp/nik', payload);

    if (status !== 1) {
      throw new Error('Gagal mengambil data VSWP (NIK)');
    }

    return data;
  },
};

export default vswpApi;
