import type { TReturPmForm } from '../types/types';

const mapObjekFakturToRetur = (item: any) => ({
  brgJasa: item.brgJasa,
  kdBrgJasa: item.kdBrgJasa,
  namaBrgJasa: item.namaBrgJasa,
  satuanBrgJasa: item.satuanBrgJasa,

  hargaSatuan: Number(item.hargaSatuan),
  jmlBrgJasa: Number(item.jmlBrgJasa),
  returJmlBrgJasa: Number(item.jmlBrgJasa), // default full retur

  totalHarga: Number(item.totalHarga),
  diskon: Number(item.diskon ?? 0),
  returDiskon: 0,

  cekDppLain: item.cekDppLain ? 1 : 0,

  dpp: Number(item.dpp),
  returDpp: Number(item.dpp ?? 0),

  dppLain: Number(item.dppLain),
  returDppLain: Number(item.dppLain ?? 0),

  tarifPpn: Number(item.tarifPpn),
  ppn: Number(item.ppn),
  returPpn: Number(item.ppn ?? 0),

  tarifPpnbm: Number(item.tarifPpnbm ?? 0),
  ppnbm: Number(item.ppnbm ?? 0),
  returPpnbm: Number(item.ppnbm ?? 0),
});

export const mapTrx015ToReturForm = (res: any): TReturPmForm => ({
  // header
  masaPajakRetur: res.masapajak,
  tahunPajakRetur: res.tahunpajak,
  // API -> Form
  tanggalRetur: new Date(),

  nomorFakturDiretur: res.nomorfaktur,
  npwpPembeli: res.npwppembeli,
  npwpPenjual: res.npwppenjual,
  isCreditable: 1,

  // total (WAJIB ADA)
  nilaiReturDpp: Number(res.totaldpp ?? 0),
  nilaiReturDppLain: Number(res.totaldpplain ?? 0),
  nilaiReturDiskon: 0,
  nilaiReturPpn: Number(res.totalppn ?? 0),
  nilaireturppnbm: Number(res.totalppnbm ?? 0),

  // detail
  objekFaktur: res.objekFaktur.map(mapObjekFakturToRetur),
});
