import dayjs from 'dayjs';
import { z } from 'zod';

export const ReturPmSchema = z.object({
  //   masaPajakRetur: z.string().min(1),
  //   tahunPajakRetur: z.string(),
  //   tanggalRetur: z.string().length(8),
  //   tanggalRetur: z.preprocess((val) => {
  //     if (val instanceof Date) {
  //       return dayjs(val).format('DDMMYYYY');
  //     }
  //     return val;
  //   }, z.string().nonempty('Tanggal retur wajib diisi')),
  tahunPajakRetur: z.preprocess((val) => {
    if (val instanceof Date) return dayjs(val).format('YYYY');
    // jika kadang value Dayjs (unlikely) - ikut dayjs parsing
    return val;
  }, z.string().nonempty('Tahun Pajak wajib diisi')),

  masaPajakRetur: z.preprocess((val) => {
    if (val instanceof Date) return dayjs(val).format('MM');
    return val;
  }, z.string().nullable()),

  tanggalRetur: z.preprocess((val) => {
    if (val instanceof Date) return dayjs(val).format('DDMMYYYY');
    return val;
  }, z.string().nonempty('Tanggal retur wajib diisi')),

  nomorFakturDiretur: z.string().min(1),
  npwpPembeli: z.string().length(16),
  npwpPenjual: z.string().length(16),

  isCreditable: z.union([z.literal(0), z.literal(1)]),

  nilaiReturDpp: z.number(),
  nilaiReturDppLain: z.number(),
  nilaiReturDiskon: z.number(),
  nilaiReturPpn: z.number(),
  nilaireturppnbm: z.number(),

  objekFaktur: z.array(
    z.object({
      brgJasa: z.enum(['GOODS', 'SERVICES']),
      kdBrgJasa: z.string(),
      namaBrgJasa: z.string(),
      satuanBrgJasa: z.string(),

      hargaSatuan: z.number(),
      jmlBrgJasa: z.number(),
      returJmlBrgJasa: z.number(),

      totalHarga: z.number(),
      diskon: z.number(),
      returDiskon: z.number(),

      cekDppLain: z.number(),

      dpp: z.number(),
      returDpp: z.number(),

      dppLain: z.number(),
      returDppLain: z.number(),

      tarifPpn: z.number(),
      ppn: z.number(),
      returPpn: z.number(),

      tarifPpnbm: z.number(),
      ppnbm: z.number(),
      returPpnbm: z.number(),
    })
  ),
});
