import { useQuery } from '@tanstack/react-query';
import type { TGoodsResult } from '../types/types';
import fakturApi from '../utils/api';

export const useGetGoods = (params?: Record<string, any>) =>
  useQuery<TGoodsResult>({
    queryKey: ['goods-dokumen-lain-keluaran', params],
    enabled: !!params, // ⭐️ ADD THIS
    queryFn: async () => {
      const res = await fakturApi.getGoods(params);
      return res.data;
    },
  });

export default useGetGoods;
