import { useMutation } from '@tanstack/react-query';
import type { TCancelRequest, TCancelResponse } from '../types/types';
import fakturApi from '../utils/api';

const useCancelDokumenLainKeluaran = (props?: any) =>
  useMutation<TCancelResponse, Error, TCancelRequest>({
    mutationKey: ['cancel-dokumen-lain-keluaran'],
    mutationFn: (payload) => fakturApi.cancelDokumenLainKeluaran(payload),
    ...props,
  });

export default useCancelDokumenLainKeluaran;
