import { useMutation } from '@tanstack/react-query';
import type { TBaseResponseAPI, TDeleteSspRequest } from '../types/types';
import sspApi from '../utils/api';

const useDeleteSsp = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteSspRequest>({
    mutationKey: ['delete-ssp'],
    mutationFn: (payload) => sspApi.deleteSsp(payload),
    ...props,
  });

export default useDeleteSsp;
