import { useMutation } from '@tanstack/react-query';
import type { TBaseResponseAPI, TDeleteRequest } from '../types/types';
import fakturApi from '../utils/api';

const useDeleteDokumenLainKeluaran = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteRequest>({
    mutationKey: ['delete-dokumen-lain-keluaran'],
    mutationFn: (payload) => fakturApi.deleteDokumenLainKeluaran(payload),
    ...props,
  });

export default useDeleteDokumenLainKeluaran;
