import React from 'react';
import Chip from '@mui/material/Chip';
import Box from '@mui/material/Box';
import { HourglassTopRounded, DoneRounded, CloseRounded } from '@mui/icons-material';
import { IconButton, Tooltip } from '@mui/material';

type Props = {
  value?: string;
  revNo?: number;
  fgpelunasan?: string | boolean;
  fguangmuka?: string | boolean;
  valid?: string;
  credit?: string | null;
};

const StatusChip: React.FC<Props> = ({ value, fgpelunasan, fguangmuka, credit, valid }) => {
  if (!value) return <Chip label="" size="small" />;

  const componentCredit = (() => {
    if (credit === 'UNCREDITED') {
      return (
        <Chip
          label="UNCREDITED"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#d32f2f',
            color: '#d32f2f',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    } else if (credit === 'CREDITED') {
      return (
        <Chip
          label="CREDITED"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    } else if (credit === null) {
      return (
        <Chip
          label="Belum diKreditkan"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    }

    return null;
  })();

  const componentValid = (() => {
    if (valid === 'Valid') {
      return (
        <Tooltip title="Valid">
          <IconButton
            size="small"
            sx={{
              backgroundColor: '#34C759',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: '#34C759',
              },
            }}
          >
            <DoneRounded style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      );
    } else {
      return (
        <Tooltip title="Invalid">
          <IconButton
            size="small"
            sx={{
              backgroundColor: '#DC2626',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: '#DC2626',
              },
            }}
          >
            <CloseRounded style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      );
    }
    return null;
  })();

  let mainComponent: React.ReactNode = <Chip label={value} size="small" />;

  if (value === 'WAITING FOR AMENDMENT') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Normal Pengganti"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Tooltip title="Menunggu Persetujuan">
          <IconButton
            size="small"
            sx={{
              backgroundColor: 'orange',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: 'orange',
              },
            }}
          >
            <HourglassTopRounded style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      </Box>
    );
  } else if (value === 'APPROVED') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Normal"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Chip
          label="Approved"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      </Box>
    );
  } else if (value === 'AMENDED') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Diganti"
          size="small"
          variant="outlined"
          sx={{
            color: '#fff',
            backgroundColor: '#f38c28',
            borderRadius: '8px',
            fontWeight: 500,
            border: 'none',
            boxShadow: '0 1px 2px rgba(0, 0, 0, 0.15)',
          }}
        />
        <Chip
          label="Approved"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      </Box>
    );
  } else if (value === 'CANCELLED') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Batal"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#d32f2f',
            color: '#d32f2f',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Chip
          label="Approved"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      </Box>
    );
  } else if (value === 'WAITING FOR CANCELLATION') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Batal"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#d32f2f',
            color: '#d32f2f',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Tooltip title="Menunggu Persetujuan">
          <IconButton
            size="small"
            sx={{
              backgroundColor: 'orange',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: 'orange',
              },
            }}
          >
            <HourglassTopRounded style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      </Box>
    );
  }

  // ✅ Gabungkan komponen utama + tambahan
  return (
    <Box
      sx={{
        display: 'inline-flex',
        alignItems: 'center',
        gap: '8px',
      }}
    >
      {mainComponent}
      {componentCredit}
      {componentValid}
    </Box>
  );
};

export default React.memo(StatusChip);
