import { Box } from '@mui/material';
import Grid from '@mui/material/Grid';
import { useFormContext } from 'react-hook-form';
import { Field } from 'src/components/hook-form';
import { fgPerhitunganOptions, KELAMIN, KELAMIN_TEXT } from 'src/sections/bupot-21-26/constant';

type IdentitasProps = {
  isPengganti?: boolean;
  kodeNegetaOptions: {
    label: string;
    value: string;
  }[];
  ptkpOptions: {
    value: string;
    label: string;
  }[];
};

const genderOptions = [
  { value: KELAMIN.LAKI, label: KELAMIN_TEXT[KELAMIN.LAKI] },
  { value: KELAMIN.PEREMPUAN, label: KELAMIN_TEXT[KELAMIN.PEREMPUAN] },
];

const Identitas = ({ isPengganti, kodeNegetaOptions, ptkpOptions }: IdentitasProps) => {
  const { setValue, watch } = useFormContext();
  const fgKaryawanAsing = watch('fgKaryawanAsing');

  const handleFgPerhitunganChange = (val: any) => {
    const newValue = val.target.value;
    const newIsGrossUp = newValue === '1';

    setValue('fgPerhitungan', newValue);
    setValue('isGrossUp', newIsGrossUp);
  };

  return (
    <>
      <Grid container rowSpacing={2} alignItems="center" columnSpacing={2} sx={{ mb: 4 }}>
        {/* NPWP dengan onChange langsung */}
        <Grid size={{ md: 6 }}>
          <Field.Text
            name="npwp"
            label="NPWP/NIK"
            onChange={(e) => {
              const value = e.target.value.replace(/\D/g, '').slice(0, 16); // hanya angka, max 16
              setValue('npwp', value, { shouldValidate: true, shouldDirty: true });
              setValue('nitku', value.length === 16 ? value + '000000' : value, {
                shouldValidate: true,
                shouldDirty: true,
              });
            }}
            disabled={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="nama" label="Nama" disabled={isPengganti} />
        </Grid>
        <Grid size={{ md: 12 }}>
          <Field.Text name="alamat" label="Alamat" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Autocomplete
            name="optJnsKelamin"
            label="Jenis Kelamin"
            options={genderOptions}
            readOnly={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 6 }} display="flex" justifyContent="space-between">
          <Field.RadioGroup
            row
            name="fgPerhitungan"
            label="Metode Pemotongan"
            options={fgPerhitunganOptions}
            onChange={handleFgPerhitunganChange}
          />

          <Field.Autocomplete
            name="statusPtkp"
            label="Status/Jumlah Tanggungan untuk PTKP"
            options={ptkpOptions}
            sx={{
              width: '65%',
            }}
            renderOption={(props, option, state, ownerState) => {
              console.log('🚀 ~ Identitas ~ option:', option);
              const { key, ...optionProps } = props;
              return (
                <Box
                  key={key}
                  sx={{
                    letterSpacing: '1.5px',
                  }}
                  component="li"
                  {...optionProps}
                >
                  {ownerState.getOptionLabel(option)}
                </Box>
              );
            }}
          />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="namaJabatan" label="Nama Jabatan" disabled={isPengganti} />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="email" label="Email (optional)" disabled={isPengganti} />
        </Grid>
        <Grid size={{ md: 3 }} alignSelf="center">
          <Field.Checkbox
            name="fgKaryawanAsing"
            label="Status Karyawan Asing"
            disabled={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 3 }}>
          <Field.Autocomplete
            name="kodeNegara"
            label="Negara"
            options={kodeNegetaOptions}
            readOnly={!fgKaryawanAsing}
            disabled={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text
            name="passport"
            label="Paspor"
            slotProps={{
              input: {
                readOnly: !fgKaryawanAsing,
              },
            }}
            disabled={isPengganti}
          />
        </Grid>
      </Grid>

      {/* Tambah / Hapus Keterangan */}
      {/* <Box sx={{ display: 'flex', gap: 2, mb: 3 }}>
        <Box
          sx={{
            borderRadius: '18px',
            border: jumlahKeterangan >= maxKeterangan ? '1px solid #eee' : '1px solid #2e7d3280',
            color: jumlahKeterangan >= maxKeterangan ? '#eee' : '#2e7d3280',
            p: '0px 10px',
          }}
        >
          <Button disabled={jumlahKeterangan >= maxKeterangan} onClick={handleTambah}>
            Tambah Keterangan
          </Button>
        </Box>
        <Box
          sx={{
            borderRadius: '18px',
            border: jumlahKeterangan === 0 ? '1px solid #eee' : '1px solid #f44336',
            color: jumlahKeterangan === 0 ? '#eee' : '#f44336',
            p: '0px 10px',
          }}
        >
          <Button disabled={jumlahKeterangan === 0} onClick={handleHapus}>
            Hapus Keterangan
          </Button>
        </Box>
      </Box>

      <Box sx={{ mb: 3 }}>
        {Array.from({ length: jumlahKeterangan }).map((_, i) => (
          <Grid size={{ md: 12 }} key={i}>
            <Field.Text
              sx={{ mb: 2 }}
              name={`keterangan${i + 1}`}
              label={`Keterangan Tambahan ${i + 1}`}
            />
          </Grid>
        ))}
      </Box> */}
    </>
  );
};

export default Identitas;
