import type {
  TableReturFakturPMResult,
  TBaseResponseAPI,
  TCancelReturPMRequest,
  TGoodsResult,
  TPostReturPMRequest,
  TSatuanResult,
  TServiceResult,
} from '../types/types';

import unifikasiClient from './unifikasiClient';

const fakturApi = () => {};

// API untuk get list table
fakturApi.getReturPM = async (config: any) => {
  const {
    data: { message, metaPage, data },
    status: statusCode,
  } = await unifikasiClient.get<TBaseResponseAPI<TableReturFakturPMResult>>('/IF_TXR_017', {
    ...config,
  });

  if (statusCode !== 200) {
    throw new Error(message);
  }

  return { total: metaPage ? Number(metaPage.totalRow) : 0, data };
};

fakturApi.getReturPMById = async (id: string) => {
  const res = await unifikasiClient.get('/IF_TXR_017', { params: { id } });

  const {
    data: { status, message, data },
    status: statusCode,
  } = res;

  if (statusCode !== 200 || status?.toLowerCase() !== 'success') {
    console.error('getRetur PM failed:', { statusCode, status, message });
    throw new Error(message || 'Gagal mengambil data FakturPM');
  }

  const dnData = Array.isArray(data) ? data[0] : data;

  return dnData;
};

fakturApi.getFakturPMById = async (id: string) => {
  const res = await unifikasiClient.get('/IF_TXR_015', { params: { id } });

  const {
    data: { status, message, data },
    status: statusCode,
  } = res;

  if (statusCode !== 200 || status?.toLowerCase() !== 'success') {
    console.error('getRetur PM failed:', { statusCode, status, message });
    throw new Error(message || 'Gagal mengambil data FakturPM');
  }

  const dnData = Array.isArray(data) ? data[0] : data;

  return dnData;
};

fakturApi.postReturPM = async (payload: TPostReturPMRequest) => {
  const {
    data: { status, message, data },
    status: statusCode,
  } = await unifikasiClient.post<TBaseResponseAPI<any>>('/IF_TXR_017/create', payload);

  if (statusCode !== 200 || status?.toLowerCase() !== 'success') {
    console.error('Create Retur PM failed:', { statusCode, status, message });
    throw new Error(message || 'Gagal membuat Retur Pajak Masukan');
  }

  return data;
};
fakturApi.uploadReturPM = async (payload: { id: string }) => {
  const {
    data: { status, message, data },
    status: statusCode,
  } = await unifikasiClient.post('/IF_TXR_017/upload', payload);

  if (statusCode !== 200 || status?.toLowerCase() !== 'success') {
    console.error('Upload Pajak Masukan failed:', { statusCode, status, message });
    throw new Error(message || 'Gagal memvalidasi retur Pajak Masukan');
  }

  return data;
};

fakturApi.cancelReturPM = async (payload: TCancelReturPMRequest) => {
  const {
    data: { status, message, data },
    status: statusCode,
  } = await unifikasiClient.post('/IF_TXR_017/batal', payload);
  if (statusCode !== 200 || status?.toLowerCase() !== 'success') {
    console.error('Cancel Return PM failed:', { statusCode, status, message });
    throw new Error(message || 'Gagal mengcancel Faktur Pajak Masukan');
  }

  return data;
};

fakturApi.deleteReturPM = async (payload: { id: string }) => {
  const {
    data: { status, message, data },
    status: statusCode,
  } = await unifikasiClient.post('/IF_TXR_017/delete', payload);

  if (statusCode !== 200 || status?.toLowerCase() !== 'success') {
    console.error('Delete Pajak Masukan failed:', { statusCode, status, message });
    throw new Error(message || 'Gagal delete retur Pajak Masukan');
  }

  return data;
};

fakturApi.getGoods = async (params?: Record<string, any>) => {
  const response = await unifikasiClient.get<TBaseResponseAPI<TGoodsResult>>('/sandbox/mst_goods', {
    params,
  });

  const body = response.data;

  if (response.status !== 200 || body.status !== 'success') {
    throw new Error(body.message);
  }

  return body;
};

fakturApi.getServices = async (params?: Record<string, any>) => {
  const response = await unifikasiClient.get<TBaseResponseAPI<TServiceResult>>(
    '/sandbox/mst_services',
    {
      params,
    }
  );

  const body = response.data;

  if (response.status !== 200 || body.status !== 'success') {
    throw new Error(body.message);
  }

  return body;
};

fakturApi.getSatuan = async (params?: Record<string, any>) => {
  const response = await unifikasiClient.get<TBaseResponseAPI<TSatuanResult>>(
    '/sandbox/mst_satuan',
    {
      params,
    }
  );

  const body = response.data;

  if (response.status !== 200 || body.status !== 'success') {
    throw new Error(body.message);
  }

  return body;
};

export default fakturApi;
