export const KODE_DOKUMEN = {
  EBKPTB: 'OSD.00702',
  EJKP: 'OSD.00701',
} as const;

export type KodeDokumen = (typeof KODE_DOKUMEN)[keyof typeof KODE_DOKUMEN];

export interface KodeDokumenOption {
  value: KodeDokumen;
  label: string;
}

export const KODE_DOKUMEN_OPTIONS: KodeDokumenOption[] = [
  {
    value: KODE_DOKUMEN.EBKPTB,
    label: 'EBKPTB untuk Ekspor BKP Tidak Berwujud',
  },
  {
    value: KODE_DOKUMEN.EJKP,
    label: 'Pemberitahuan Ekspor Jasa',
  },
];

// helper aman (formatter / renderCell / fallback)
export const getKodeDokumenLabel = (value?: string) =>
  KODE_DOKUMEN_OPTIONS.find((opt) => opt.value === value)?.label ?? value;
