import { useMutation } from '@tanstack/react-query';
import dayjs from 'dayjs';
import type { TPostSspRequest } from '../types/types';
import sspApi from '../utils/api';

/**
 * Transformasi data form menjadi payload untuk endpoint IF_TXR_070
 */
const transformParams = ({ isPengganti = false, ...sspData }: any): TPostSspRequest => {
  const {
    id,
    idBupot,
    noBupot,
    kanal,
    npwpPemotong,
    idTku,
    msPajak,
    tahunPajak,
    fgFasilitas,
    noDokLainnya,
    kdObjPjk,
    pasalPph,
    statusPph,
    dpp,
    tarif,
    pphDipotong,
    kap,
    kjs,
    dokReferensi,
    tglPemotongan,
    userId,
    revNo: initialRevNo,
    glAccount,
    namaDok,
    nomorDok,
    tglDok,
  } = sspData;

  const revNo = isPengganti
    ? parseInt(initialRevNo?.toString() || '0', 10) + 1
    : parseInt(initialRevNo?.toString() || '0', 10);

  return {
    id: !isPengganti ? (id ?? null) : null,
    noBupot: noBupot ?? '',
    idBupot: idBupot ?? '',
    kanal: kanal ?? '14',
    npwpPemotong: npwpPemotong ?? '',
    idTku: idTku ?? '',
    masaPajak: msPajak ? String(msPajak).padStart(2, '0') : '',
    tahunPajak: Number(tahunPajak ?? dayjs().year()),
    sertifikatInsentifDipotong: fgFasilitas ?? '9',
    nomorSertifikatInsentif: noDokLainnya ?? null,
    kodeObjekPajak: kdObjPjk ?? '',
    pasalPph: pasalPph ?? '',
    statusPph: statusPph ?? '',
    dpp: Number(dpp ?? 0),
    tarif: Number(tarif ?? 0),
    pphDipotong: Number(pphDipotong ?? 0),
    kap: Number(kap ?? 0),
    kjs: Number(kjs ?? 0),

    dokReferensi: (() => {
      // fallback dari namaDok, nomorDok, tglDok
      if (dokReferensi && Array.isArray(dokReferensi) && dokReferensi.length > 0)
        return dokReferensi;

      if (!namaDok || !nomorDok || !tglDok) return [];
      const parsedDate = dayjs(tglDok);
      const formatted = parsedDate.isValid() ? parsedDate.format('DDMMYYYY') : '';
      return [
        {
          dokReferensi: namaDok,
          nomorDokumen: nomorDok,
          tanggal_Dokumen: formatted,
        },
      ];
    })(),

    tglPemotongan: tglPemotongan ? dayjs(tglPemotongan).format('DDMMYYYY') : '',
    userId: userId ?? '',
    revNo,
    glAccount: glAccount ?? '',
  };
};

/**
 * Hook untuk menyimpan data SSP ke endpoint IF_TXR_070
 */
const useSaveSsp = (props?: any) =>
  useMutation({
    mutationKey: ['save-ssp'],
    mutationFn: (params: any) => sspApi.saveSsp(transformParams(params)),
    ...props,
  });

export default useSaveSsp;
