import { useMutation } from '@tanstack/react-query';
import type { TCancelSspRequest, TCancelSspResponse } from '../types/types';
import sspApi from '../utils/api';

const useCancelSsp = (props?: any) =>
  useMutation<TCancelSspResponse, Error, TCancelSspRequest>({
    mutationKey: ['cancel-ssp'],
    mutationFn: (payload) => sspApi.cancel(payload),
    ...props,
  });

export default useCancelSsp;
