import React from 'react';
// import Grid from '@mui/system/Unstable_Grid';
import { Skeleton, Grid } from '@mui/material';

function FormSkeleton({ numberOfRows = 5 }) {
  return (
    <Grid container spacing={2}>
      {[...Array(numberOfRows)].map((_, index) => (
        <React.Fragment key={index}>
          <Grid size={{ md: 6 }}>
            <Skeleton variant="rounded" sx={{ width: '100%', height: 50 }} />
          </Grid>
          <Grid size={{ md: 6 }}>
            <Skeleton variant="rounded" sx={{ width: '100%', height: 50 }} />
          </Grid>
        </React.Fragment>
      ))}
    </Grid>
  );
}

export default FormSkeleton;
