import React from 'react';
import { Alert, Typography, Button, IconButton, Box } from '@mui/material';
import CloseIcon from '@mui/icons-material/Close';

interface AlertInformationDppLainProps {
  onClose: () => void;
}

const AlertInformationDppLain: React.FC<AlertInformationDppLainProps> = ({ onClose }) => (
  <Alert
    icon={
      <Box
        component="img"
        src="/assets/icon-info-dpp-lain.svg"
        alt="Info DPP Lain"
        sx={{ width: 60, height: 60 }}
      />
    }
    severity="warning"
    sx={{
      position: 'relative',
      border: '1px solid #FACC15', // yellow-400
      alignItems: 'center',
      bgcolor: '#FFFBEB', // yellow-50
    }}
  >
    {/* Main Content */}
    <Box sx={{ display: 'flex', flexDirection: 'column' }}>
      <Typography variant="body2" sx={{ fontWeight: 600 }}>
        Nilai DPP Nilai Lain/DPP diisi dengan memperhatikan ketentuan perpajakan yang berlaku.
      </Typography>

      <Typography variant="body2">Referensi:</Typography>

      {/* List */}
      <Box component="ul" sx={{ listStyle: 'none', pl: 0 }}>
        <Box component="li" sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
          <Box sx={{ width: 8, height: 8, borderRadius: '50%', bgcolor: '#663C00' }} />
          <Typography variant="body2" component="span" sx={{ pt: 1 }}>
            Peraturan Menteri Keuangan Nomor 131 Tahun 2024.{' '}
            <Button
              component="a"
              href="https://datacenter.ortax.org/ortax/aturan/show/26049"
              target="_blank"
              rel="noreferrer"
              variant="text"
              color="primary"
              size="small"
              sx={{
                minWidth: 0,
                p: 0,
                textTransform: 'none',
                '&:hover': { bgcolor: 'transparent' },
              }}
            >
              Klik di sini
            </Button>
          </Typography>
        </Box>
      </Box>
    </Box>

    {/* Close Button */}
    <IconButton
      aria-label="Close Dialog"
      onClick={onClose}
      size="small"
      sx={{ position: 'absolute', top: 8, right: 8 }}
    >
      <CloseIcon fontSize="small" />
    </IconButton>
  </Alert>
);

export default AlertInformationDppLain;
