import { useMutation } from '@tanstack/react-query';
import type { TCancelResponse, TCancelReturPKRequest } from '../types/types';
import fakturApi from '../utils/api';

const useCancelReturPK = (props?: any) =>
  useMutation<TCancelResponse, Error, TCancelReturPKRequest>({
    mutationKey: ['cancel-retur-pk'],
    mutationFn: (payload) => fakturApi.cancelReturPK(payload),
    ...props,
  });

export default useCancelReturPK;
