// const formatDate = (iso: string) => {
//   if (!iso) return '';
//   const d = new Date(iso);
//   const dd = String(d.getUTCDate()).padStart(2, '0');
//   const mm = String(d.getUTCMonth() + 1).padStart(2, '0');
//   const yyyy = d.getUTCFullYear();
//   return `${dd}${mm}${yyyy}`;
// };

// export const normalizePayloadCetakPdfDetail = (raw: any) => ({
//   alamatPembeli: raw.alamatpembeli || '',
//   alamatPenjual: raw.alamatpenjual || 'Jati Bening, Bekasi',
//   detailTransaksi: raw.detailtransaksi || '',
//   emailPembeli: raw.emailpembeli || '',
//   fgPelunasan: raw.fgpelunasan || false,
//   fgUangMuka: raw.fguangmuka || false,
//   idKeteranganTambahan: raw.idketerangantambahan || '',
//   idLainPembeli: raw.idlainpembeli || '',
//   jumlahUangMuka: String(raw.jumlahuangmuka || '0'),
//   kdNegaraPembeli: raw.kdnegarapembeli || '',
//   keteranganTambahan: raw.keterangantambahan || '',
//   kodeApproval: raw.kodeapproval || '',
//   masaPajak: raw.masapajak || '',
//   namaPembeli: raw.namapembeli || '',
//   namaPenandatangan: raw.namapenandatangan || raw.tkupembeli || '',
//   namaPenjual: raw.namatokopenjual || '',
//   nikPaspPembeli: raw.nikpasppembeli || '',
//   nomorFaktur: raw.nomorfaktur || '',
//   npwpPembeli: raw.npwppembeli || '',
//   npwpPenjual: raw.npwppenjual || '',

//   objekFaktur: (raw.objekFaktur || []).map((x: any) => ({
//     brgJasa: x.brgJasa,
//     kdBrgJasa: x.kdBrgJasa,
//     namaBrgJasa: x.namaBrgJasa,
//     satuanBrgJasa: x.satuanBrgJasa,
//     jmlBrgJasa: String(x.jmlBrgJasa),
//     hargaSatuan: String(x.hargaSatuan),
//     totalHarga: String(x.totalHarga),
//     diskon: String(x.diskon),
//     dpp: String(x.dpp),
//     dppLain: String(x.dppLain),
//     ppn: String(x.ppn),
//     ppnbm: String(x.ppnbm),
//     tarifPpn: String(x.tarifPpn),
//     tarifPpnbm: String(x.tarifPpnbm),
//     cekDppLain: String(x.cekDppLain),
//   })),

//   qrcode: raw.qrcode || 'urlttd',
//   refDoc: raw.refdoc || '',
//   referensi: raw.referensi || '',
//   statusFaktur: raw.statusfaktur || '',
//   tahunPajak: raw.tahunpajak || '',
//   tanggalFaktur: formatDate(raw.tanggalfaktur),
//   tempatPenandatangan: raw.tempatpenandatangan || 'BEKASI',
//   totalDiskon: '0',
//   totalDpp: String(raw.totaldpp || '0'),
//   totalDppLain: String(raw.totaldpplain || '0'),
//   totalPpn: String(raw.totalppn || '0'),
//   totalPpnbm: String(raw.totalppnbm || '0'),
// });

const formatDate = (iso: string) => {
  if (!iso) return '';
  const d = new Date(iso);
  const dd = String(d.getUTCDate()).padStart(2, '0');
  const mm = String(d.getUTCMonth() + 1).padStart(2, '0');
  const yyyy = d.getUTCFullYear();
  return `${dd}${mm}${yyyy}`;
};

export const normalizePayloadCetakPdfDetail = (raw: any) => {
  // 🧮 Hitung total diskon dari objekFaktur
  const totalDiskon = Array.isArray(raw.objekFaktur)
    ? raw.objekFaktur.reduce((sum: any, x: any) => sum + Number(x.diskon ?? 0), 0)
    : 0;

  return {
    alamatPembeli: raw.alamatpembeli || '',
    alamatPenjual: raw.alamatpenjual || 'Jati Bening, Bekasi',
    detailTransaksi: raw.detailtransaksi || '',
    emailPembeli: raw.emailpembeli || '',
    fgPelunasan: raw.fgpelunasan || false,
    fgUangMuka: raw.fguangmuka || false,
    idKeteranganTambahan: raw.idketerangantambahan || '',
    idLainPembeli: raw.idlainpembeli || '',
    jumlahUangMuka: String(raw.jumlahuangmuka || '0'),
    kdNegaraPembeli: raw.kdnegarapembeli || '',
    keteranganTambahan: raw.keterangantambahan || '',
    kodeApproval: raw.kodeapproval || '',
    masaPajak: raw.masapajak || '',
    namaPembeli: raw.namapembeli || '',
    namaPenandatangan: raw.namapenandatangan || raw.tkupembeli || '',
    namaPenjual: raw.namatokopenjual || '',
    nikPaspPembeli: raw.nikpasppembeli || '',
    nomorFaktur: raw.nomorfaktur || '',
    npwpPembeli: raw.npwppembeli || '',
    npwpPenjual: raw.npwppenjual || '',

    objekFaktur: (raw.objekFaktur || []).map((x: any) => ({
      brgJasa: x.brgJasa,
      kdBrgJasa: x.kdBrgJasa,
      namaBrgJasa: x.namaBrgJasa,
      satuanBrgJasa: x.satuanBrgJasa,
      jmlBrgJasa: String(x.jmlBrgJasa),
      hargaSatuan: String(x.hargaSatuan),
      totalHarga: String(x.totalHarga),
      diskon: String(x.diskon),
      dpp: String(x.dpp),
      dppLain: String(x.dppLain),
      ppn: String(x.ppn),
      ppnbm: String(x.ppnbm),
      tarifPpn: String(x.tarifPpn),
      tarifPpnbm: String(x.tarifPpnbm),
      cekDppLain: String(x.cekDppLain),
    })),

    qrcode: raw.qrcode || 'urlttd',
    refDoc: raw.refdoc || '',
    referensi: raw.referensi || '',
    statusFaktur: raw.statusfaktur || '',
    tahunPajak: raw.tahunpajak || '',
    tanggalFaktur: formatDate(raw.tanggalfaktur),
    tempatPenandatangan: raw.tempatpenandatangan || 'BEKASI',

    // <<-- hasil penjumlahan diskon
    totalDiskon: String(totalDiskon),

    totalDpp: String(raw.totaldpp || '0'),
    totalDppLain: String(raw.totaldpplain || '0'),
    totalPpn: String(raw.totalppn || '0'),
    totalPpnbm: String(raw.totalppnbm || '0'),
  };
};
