import { useQuery } from '@tanstack/react-query';
import type { TServiceResult } from '../types/types';
import fakturApi from '../utils/api';

export const useGetServices = (params?: Record<string, any>) =>
  useQuery<TServiceResult>({
    queryKey: ['services-faktur-pk'],
    queryFn: async () => {
      const res = await fakturApi.getServices(params);
      return res.data; // ✅ langsung array negara
    },
  });

export default useGetServices;
