import { kebabCase } from 'es-toolkit';

import { _id, _postTitles } from 'src/_mock/assets';

// ----------------------------------------------------------------------

const MOCK_ID = _id[1];
const MOCK_TITLE = _postTitles[2];

const ROOTS = {
  AUTH: '/auth',
  AUTH_DEMO: '/auth-demo',
  DASHBOARD: '/dashboard',
  UNIFIKASI: '/unifikasi',
  PPH21: '/pph21',
  FAKTUR: '/faktur',
};

// ----------------------------------------------------------------------

export const paths = {
  comingSoon: '/coming-soon',
  maintenance: '/maintenance',
  pricing: '/pricing',
  payment: '/payment',
  about: '/about-us',
  contact: '/contact-us',
  faqs: '/faqs',
  page403: '/error/403',
  page404: '/error/404',
  page500: '/error/500',
  components: '/components',
  docs: 'https://docs.minimals.cc/',
  changelog: 'https://docs.minimals.cc/changelog/',
  zoneStore: 'https://mui.com/store/items/zone-landing-page/',
  minimalStore: 'https://mui.com/store/items/minimal-dashboard/',
  freeUI: 'https://mui.com/store/items/minimal-dashboard-free/',
  figmaUrl: 'https://www.figma.com/design/WadcoP3CSejUDj7YZc87xj/%5BPreview%5D-Minimal-Web.v7.3.0',
  product: {
    root: `/product`,
    checkout: `/product/checkout`,
    details: (id: string) => `/product/${id}`,
    demo: { details: `/product/${MOCK_ID}` },
  },
  post: {
    root: `/post`,
    details: (title: string) => `/post/${kebabCase(title)}`,
    demo: { details: `/post/${kebabCase(MOCK_TITLE)}` },
  },
  // AUTH
  auth: {
    amplify: {
      signIn: `${ROOTS.AUTH}/amplify/sign-in`,
      verify: `${ROOTS.AUTH}/amplify/verify`,
      signUp: `${ROOTS.AUTH}/amplify/sign-up`,
      updatePassword: `${ROOTS.AUTH}/amplify/update-password`,
      resetPassword: `${ROOTS.AUTH}/amplify/reset-password`,
    },
    jwt: {
      signIn: `${ROOTS.AUTH}/jwt/sign-in`,
      signUp: `${ROOTS.AUTH}/jwt/sign-up`,
    },
    firebase: {
      signIn: `${ROOTS.AUTH}/firebase/sign-in`,
      verify: `${ROOTS.AUTH}/firebase/verify`,
      signUp: `${ROOTS.AUTH}/firebase/sign-up`,
      resetPassword: `${ROOTS.AUTH}/firebase/reset-password`,
    },
    auth0: { signIn: `${ROOTS.AUTH}/auth0/sign-in` },
    supabase: {
      signIn: `${ROOTS.AUTH}/supabase/sign-in`,
      verify: `${ROOTS.AUTH}/supabase/verify`,
      signUp: `${ROOTS.AUTH}/supabase/sign-up`,
      updatePassword: `${ROOTS.AUTH}/supabase/update-password`,
      resetPassword: `${ROOTS.AUTH}/supabase/reset-password`,
    },
  },
  authDemo: {
    split: {
      signIn: `${ROOTS.AUTH_DEMO}/split/sign-in`,
      signUp: `${ROOTS.AUTH_DEMO}/split/sign-up`,
      resetPassword: `${ROOTS.AUTH_DEMO}/split/reset-password`,
      updatePassword: `${ROOTS.AUTH_DEMO}/split/update-password`,
      verify: `${ROOTS.AUTH_DEMO}/split/verify`,
    },
    centered: {
      signIn: `${ROOTS.AUTH_DEMO}/centered/sign-in`,
      signUp: `${ROOTS.AUTH_DEMO}/centered/sign-up`,
      resetPassword: `${ROOTS.AUTH_DEMO}/centered/reset-password`,
      updatePassword: `${ROOTS.AUTH_DEMO}/centered/update-password`,
      verify: `${ROOTS.AUTH_DEMO}/centered/verify`,
    },
  },
  unifikasi: {
    root: ROOTS.UNIFIKASI,
    dn: `${ROOTS.UNIFIKASI}/dn`,
    nr: `${ROOTS.UNIFIKASI}/nr`,
    ssp: `${ROOTS.UNIFIKASI}/ssp`,
    digunggung: `${ROOTS.UNIFIKASI}/digunggung`,
    digunggungNew: `${ROOTS.UNIFIKASI}/digunggung/new`,
    dipersamakan: `${ROOTS.UNIFIKASI}/dokumen-dipersamakan`,
    sptPosting: `${ROOTS.UNIFIKASI}/spt/posting`,
    sptRekam: `${ROOTS.UNIFIKASI}/spt/rekam`,
    sptPenyiapan: `${ROOTS.UNIFIKASI}/spt/Penyiapan`,
    dnNew: `${ROOTS.UNIFIKASI}/dn/new`,
    nrNew: `${ROOTS.UNIFIKASI}/nr/new`,
    sspNew: `${ROOTS.UNIFIKASI}/ssp/new`,
    dokumenDipersamakanNew: `${ROOTS.UNIFIKASI}/dokumen-dipersamakan/new`,
  },
  // Bupot 21/26
  pph21: {
    root: ROOTS.PPH21,
    bulanan: `${ROOTS.PPH21}/bulanan`,
    bulananRekam: `${ROOTS.PPH21}/bulanan/rekam`,
    bulananUbah: (id: string) => `${ROOTS.PPH21}/bulanan/${id}/ubah`,
    bulananPengganti: (id: string) => `${ROOTS.PPH21}/bulanan/${id}/pengganti`,
    bupotFinal: `${ROOTS.PPH21}/bupot-final`,
    detailsBupotFinal: (id: string) => `${ROOTS.PPH21}/bupot-final/${id}`,
    tahuan: `${ROOTS.PPH21}/tahunan`,
    detailstahuan: (id: string) => `${ROOTS.PPH21}/tahunan/${id}`,
    tahunanA2: `${ROOTS.PPH21}/tahunan-a2`,
    detailstahunanA2: (id: string) => `${ROOTS.PPH21}/tahunan-a2/${id}`,
    bupot26: `${ROOTS.PPH21}/bupot-26`,
    detailsbupot26: (id: string) => `${ROOTS.PPH21}/bupot-26/${id}`,
  },
  faktur: {
    root: ROOTS.FAKTUR,
    pm: `${ROOTS.FAKTUR}/pm`,
    pk: `${ROOTS.FAKTUR}/pk`,
    rekamPk: `${ROOTS.FAKTUR}/pk/new`,
    returPm: `${ROOTS.FAKTUR}/retur/pm`,
    returPk: `${ROOTS.FAKTUR}/retur/pk`,
    dlk: `${ROOTS.FAKTUR}/dokumen-lain/pajak-keluaran`,
    dlm: `${ROOTS.FAKTUR}/dokumen-lain/pajak-masukan`,
    returDlk: `${ROOTS.FAKTUR}/dokumen-lain/retur-pajak-keluaran`,
    returDlm: `${ROOTS.FAKTUR}/dokumen-lain/retur-pajak-masukan`,
  },
  // DASHBOARD
  dashboard: {
    root: ROOTS.DASHBOARD,
    general: {
      app: `${ROOTS.DASHBOARD}/app`,
      ecommerce: `${ROOTS.DASHBOARD}/ecommerce`,
      analytics: `${ROOTS.DASHBOARD}/analytics`,
      banking: `${ROOTS.DASHBOARD}/banking`,
      booking: `${ROOTS.DASHBOARD}/booking`,
      file: `${ROOTS.DASHBOARD}/file`,
      course: `${ROOTS.DASHBOARD}/course`,
    },
    user: {
      root: `${ROOTS.DASHBOARD}/user`,
      new: `${ROOTS.DASHBOARD}/user/new`,
      list: `${ROOTS.DASHBOARD}/user/list`,
      cards: `${ROOTS.DASHBOARD}/user/cards`,
      profile: `${ROOTS.DASHBOARD}/user/profile`,
      account: `${ROOTS.DASHBOARD}/user/account`,
      edit: (id: string) => `${ROOTS.DASHBOARD}/user/${id}/edit`,
      demo: { edit: `${ROOTS.DASHBOARD}/user/${MOCK_ID}/edit` },
    },
  },
};
