// hooks/useUpload.ts
import { useMutation } from '@tanstack/react-query';
import dnApi from '../utils/api';

const useUpload = (props?: any) =>
  useMutation({
    mutationKey: ['upload-dn'],
    mutationFn: (payload: { id: string | number }) => dnApi.upload(payload),
    ...props,
  });

export default useUpload;
