import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import bulananApi from '../utils/api';
import type { TPortBulananRequest } from '../types/types';
import queryKey from '../constant/queryKey';

const useCetakPdfDn = (
  props?: Omit<
    UseMutationOptions<any, Error, TPortBulananRequest, unknown>,
    'mutationKey' | 'mutationFn'
  >
) =>
  useMutation<any, Error, TPortBulananRequest, unknown>({
    mutationKey: queryKey.bulanan.upload,
    mutationFn: (params: TPortBulananRequest) => bulananApi.upload(params),
    ...props,
  });

export default useCetakPdfDn;
