/* eslint-disable camelcase */

// import { isStatusError } from '@utils';
// import { axiosBupot, axiosCetakBupotPDF } from 'app/store/axios';
// import qs from 'qs';
import {
  TBaseResponseAPI,
  TGetListDataKOPDnResult,
  TGetListDataTableDnResult,
  TPostDnRequest,
} from '../types/types';
import unifikasiClient from './unifikasiClient';

const dnApi = () => {};

// API untuk get list table
dnApi.getDn = async (config: any) => {
  const {
    data: { status, message, metaPage, data },
    status: statusCode,
  } = await unifikasiClient.get<TBaseResponseAPI<TGetListDataTableDnResult>>('IF_TXR_028/bpu', {
    ...config,
  });

  if (statusCode !== 200) {
    throw new Error(message);
  }

  return { total: metaPage ? Number(metaPage.totalRow) : 0, data };
};

// ✅ adjust biar bisa terima params
dnApi.getKodeObjekPajakDn = async (params?: Record<string, any>) => {
  const response = await unifikasiClient.get<TBaseResponseAPI<TGetListDataKOPDnResult>>(
    '/sandbox/mst_kop_bpu',
    { params } // ⬅️ inject ke query string
  );

  const body = response.data;

  if (response.status !== 200 || body.status !== 'success') {
    throw new Error(body.message);
  }

  return body;
};

dnApi.saveDn = async (config: TPostDnRequest) => {
  const {
    data: { status, message, data, code },
    status: statusCode,
  } = await unifikasiClient.post<TBaseResponseAPI<TPostDnRequest>>('/IF_TXR_028/bpu', {
    ...config,
  });
  if (statusCode !== 200) {
    throw new Error(message);
  }

  return data;
};

export default dnApi;
