import Card from '@mui/material/Card';
import Tab from '@mui/material/Tab';
import Tabs from '@mui/material/Tabs';
import React from 'react';

type DefaultType = {
  value?: string;
  label: string;
  onClick?: () => void;
  icon?: string | React.ReactElement<unknown, string | React.JSXElementConstructor<any>>;
};

type TabHeaderProps = {
  top: DefaultType[];
  bottom: Omit<DefaultType, 'href'>[];
  topValue: number;
  bottomValue: number;
  onTopChange: (event: React.SyntheticEvent, newValue: number) => void;
  onBottomChange: (event: React.SyntheticEvent, newValue: number) => void;
};

const TabHeader = ({
  top,
  bottom,
  topValue,
  bottomValue,
  onTopChange,
  onBottomChange,
}: TabHeaderProps) => {
  return (
    <>
      <Card sx={{ width: 'fit-content', borderRadius: '16px 16px 0px 0px', pr: 2 }}>
        <Tabs
          sx={{ '& .MuiTabs-list': { gap: 2 }, '& .MuiTabs-indicator': { display: 'none' } }}
          value={topValue}
          onChange={onTopChange}
          variant="standard"
        >
          {top.map((tab, index) =>
            tab.value ? (
              <Tab
                key={index}
                label={tab.label}
                component="a"
                href={tab.value}
                sx={{
                  p: '0px 16px',
                  '&.Mui-selected': {
                    color: '#fff !important',
                    backgroundColor: '#f38c28',
                  },
                }}
              />
            ) : (
              <Tab
                key={index}
                icon={tab.icon}
                onClick={tab.onClick}
                aria-label="Back"
                sx={{ pl: '20px' }}
              />
            )
          )}
        </Tabs>
      </Card>
      <Card sx={{ borderRadius: '0px 16px 16px 16px' }}>
        <Tabs
          sx={{ '& .MuiTabs-indicator': { display: 'none' } }}
          value={bottomValue}
          onChange={onBottomChange}
          variant="fullWidth"
        >
          {bottom.map((tab, index) => (
            <Tab
              key={index}
              label={tab.label}
              icon={tab.icon}
              iconPosition="top"
              onClick={tab.onClick}
              sx={{
                p: '25px 0px',
                flexDirection: 'column',
                justifyContent: 'center',
                alignItems: 'center',
                gap: 0.5,
                transition: 'background-color 0.2s ease',
                '&.Mui-selected': {
                  backgroundColor: 'grey.200',
                },
                '&:hover': {
                  backgroundColor: 'grey.100',
                },
              }}
            />
          ))}
        </Tabs>
      </Card>
    </>
  );
};

export default TabHeader;
