import { Controller, useFormContext } from 'react-hook-form';
import Box from '@mui/material/Box';

import Checkbox from '@mui/material/Checkbox';
import FormControlLabel from '@mui/material/FormControlLabel';
import { HelperText } from './help-text';

type RHFSingleChoiceCheckboxProps = {
  name: string; // field form yang mengontrol semua checkbox
  label: string;
  value: string; // nilai dari checkbox ini
  helperText?: React.ReactNode;
  slotProps?: {
    wrapper?: any;
    checkbox?: any;
    helperText?: any;
  };
};

export function RHFSingleChoiceCheckbox({
  name,
  label,
  value,
  helperText,
  slotProps,
}: RHFSingleChoiceCheckboxProps) {
  const { control } = useFormContext();

  return (
    <Controller
      name={name}
      control={control}
      rules={{
            validate: (fieldValue) => fieldValue ? true : `Silakan pilih salah satu: ${label}`,
        }}
      render={({ field, fieldState: { error } }) => (
        <Box {...slotProps?.wrapper}>
          <FormControlLabel
            label={label}
            control={
              <Checkbox
                checked={field.value === value} // hanya checked jika value cocok
                onChange={() => field.onChange(field.value === value ? '' : value)} // toggle
                {...slotProps?.checkbox}
              />
            }
          />
          {/* <HelperText
            {...slotProps?.helperText}
            errorMessage={error?.message}
            helperText={helperText}
          /> */}
        </Box>
      )}
    />
  );
}
