import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import queryKey from 'src/sections/bupot-21-26/constant/queryKey';
import type { TPortBulananRequest } from '../types/types';
import tahunanA1Api from '../utils/api';

const useDeleteTahunanA1 = (
  props?: Omit<
    UseMutationOptions<any, Error, TPortBulananRequest, unknown>,
    'mutationKey' | 'mutationFn'
  >
) =>
  useMutation<any, Error, TPortBulananRequest, unknown>({
    mutationKey: queryKey.tahunanA1.upload,
    mutationFn: (params: TPortBulananRequest) => tahunanA1Api.delete(params),
    ...props,
  });

export default useDeleteTahunanA1;
