// import { create } from 'zustand';

// type TableKey = string;

// interface TablePagination {
//   page: number;
//   pageSize: number;
// }

// interface PaginationState {
//   tables: Record<TableKey, TablePagination>;
//   setPagination: (table: TableKey, next: Partial<TablePagination>) => void;
//   resetPagination: (table: TableKey) => void;
// }

// export const usePaginationStore = create<PaginationState>((set) => ({
//   tables: {},
//   setPagination: (table, next) =>
//     set((state) => ({
//       tables: {
//         ...state.tables,
//         [table]: {
//           page: next.page ?? state.tables[table]?.page ?? 0,
//           pageSize: next.pageSize ?? state.tables[table]?.pageSize ?? 10,
//         },
//       },
//     })),
//   resetPagination: (table) =>
//     set((state) => ({
//       tables: {
//         ...state.tables,
//         [table]: { page: 0, pageSize: state.tables[table]?.pageSize ?? 10 },
//       },
//     })),
// }));

import { create } from 'zustand';

type TableKey = string;

interface TablePagination {
  page: number;
  pageSize: number;
}

interface PaginationState {
  tables: Record<TableKey, TablePagination>;
  setPagination: (table: TableKey, next: Partial<TablePagination>) => void;
  resetPagination: (table: TableKey) => void;
}

export const usePaginationStore = create<PaginationState>((set) => ({
  tables: {},
  setPagination: (table, next) =>
    set((state) => {
      const prev = state.tables[table] ?? { page: 0, pageSize: 10 };
      return {
        tables: {
          ...state.tables,
          [table]: {
            page: next.page ?? prev.page,
            pageSize: next.pageSize ?? prev.pageSize,
          },
        },
      };
    }),
  resetPagination: (table) =>
    set((state) => ({
      tables: {
        ...state.tables,
        [table]: { page: 0, pageSize: state.tables[table]?.pageSize ?? 10 },
      },
    })),
}));
