import dayjs from 'dayjs';
import { ActionRekam, MIN_THN_PAJAK } from '../constant';

export const currentYear = dayjs().year();

export const getHighestStartingYear = (thnAwalUnifikasi: any) =>
  Math.max(MIN_THN_PAJAK, thnAwalUnifikasi);

export const selectedInitialMonth = ({ thnAwalUnifikasi, masaAwalUnifikasi }: any) => {
  const highestYear = getHighestStartingYear(thnAwalUnifikasi);
  return highestYear > thnAwalUnifikasi ? '01' : masaAwalUnifikasi;
};

export const determineStartingMonth = ({ thnPajak, thnAwalUnifikasi, masaAwalUnifikasi }: any) => {
  const highestYear = getHighestStartingYear(thnAwalUnifikasi);
  const initialMonth = selectedInitialMonth({ thnAwalUnifikasi, masaAwalUnifikasi });

  return thnPajak >= highestYear && thnPajak <= currentYear ? initialMonth : '';
};

export const checkCurrentPage = (pathname: string) => {
  if (pathname.includes('rekam')) return ActionRekam.REKAM;
  if (pathname.includes('pengganti')) return ActionRekam.PENGGANTI;
  if (pathname.includes('pembetulan')) return ActionRekam.PEMBETULAN;
  if (pathname.includes('ubah')) return ActionRekam.UBAH;
  return ActionRekam.REKAM;
};
