import type { BoxProps } from '@mui/material/Box';

import { m } from 'framer-motion';
import { varAlpha } from 'minimal-shared/utils';

import Box from '@mui/material/Box';
import Grid from '@mui/material/Grid';
import Stack from '@mui/material/Stack';
import SvgIcon from '@mui/material/SvgIcon';
import Container from '@mui/material/Container';
import Typography from '@mui/material/Typography';

import { CONFIG } from 'src/global-config';

import { varFade, MotionViewport } from 'src/components/animate';

import { SectionTitle } from './components/section-title';
import { CircleSvg, FloatLine, FloatPlusIcon } from './components/svg-elements';

// ----------------------------------------------------------------------

const renderLines = () => (
  <>
    <FloatPlusIcon sx={{ top: 72, left: 72 }} />
    <FloatPlusIcon sx={{ bottom: 72, left: 72 }} />
    <FloatLine sx={{ top: 80, left: 0 }} />
    <FloatLine sx={{ bottom: 80, left: 0 }} />
    <FloatLine vertical sx={{ top: 0, left: 80 }} />
  </>
);

export function HomeMinimal({ sx, ...other }: BoxProps) {
  const renderDescription = () => (
    <>
      <SectionTitle
        caption="Visualizing Success"
        title="What's in"
        txtGradient="Minimal?"
        sx={{ mb: { xs: 5, md: 8 }, textAlign: { xs: 'center', md: 'left' } }}
      />

      <Stack spacing={6} sx={{ maxWidth: { sm: 560, md: 400 }, mx: { xs: 'auto', md: 'unset' } }}>
        {ITEMS.map((item) => (
          <Box
            component={m.div}
            variants={varFade('inUp', { distance: 24 })}
            key={item.title}
            sx={[{ gap: 3, display: 'flex' }]}
          >
            <SvgIcon sx={{ width: 40, height: 40 }}>{item.icon}</SvgIcon>
            <Stack spacing={1}>
              <Typography variant="h5" component="h6">
                {item.title}
              </Typography>
              <Typography sx={{ color: 'text.secondary' }}>{item.description}</Typography>
            </Stack>
          </Box>
        ))}
      </Stack>
    </>
  );

  const renderImage = () => (
    <Stack
      component={m.div}
      variants={varFade('inRight', { distance: 24 })}
      sx={{
        height: 1,
        alignItems: 'center',
        position: 'relative',
        justifyContent: 'center',
      }}
    >
      <Box
        sx={[
          (theme) => ({
            left: 0,
            width: 720,
            borderRadius: 2,
            position: 'absolute',
            bgcolor: 'background.default',
            boxShadow: `-40px 40px 80px 0px ${varAlpha(theme.vars.palette.grey['500Channel'], 0.16)}`,
            ...theme.applyStyles('dark', {
              boxShadow: `-40px 40px 80px 0px ${varAlpha(theme.vars.palette.common.blackChannel, 0.16)}`,
            }),
          }),
        ]}
      >
        <Box
          component="img"
          alt="Home chart"
          src={`${CONFIG.assetsDir}/assets/images/home/home-chart.webp`}
          sx={{ width: 720 }}
        />
      </Box>
    </Stack>
  );

  return (
    <Box
      component="section"
      sx={[
        {
          overflow: 'hidden',
          position: 'relative',
          py: { xs: 10, md: 20 },
        },
        ...(Array.isArray(sx) ? sx : [sx]),
      ]}
      {...other}
    >
      <MotionViewport>
        {renderLines()}

        <Container sx={{ position: 'relative' }}>
          <Grid container columnSpacing={{ xs: 0, md: 8 }} sx={{ position: 'relative', zIndex: 9 }}>
            <Grid size={{ xs: 12, md: 6, lg: 7 }}>{renderDescription()}</Grid>

            <Grid sx={{ display: { xs: 'none', md: 'block' } }} size={{ md: 6, lg: 5 }}>
              {renderImage()}
            </Grid>
          </Grid>

          <CircleSvg variants={varFade('in')} sx={{ display: { xs: 'none', md: 'block' } }} />
        </Container>
      </MotionViewport>
    </Box>
  );
}

// ----------------------------------------------------------------------

const ITEMS = [
  {
    title: 'Branding',
    description: 'Consistent design makes it easy to brand your own.',
    icon: (
      <svg
        width="48"
        height="48"
        viewBox="0 0 48 48"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          opacity="0.48"
          d="M17.2978 43.8278L17.0351 44.2607C17.0351 44.2607 5.35059 44.8621 5.35059 37.1297C5.35059 29.2255 15.5845 25.7636 18.7534 24.672C19.4455 24.4336 20.6797 24.0861 22.1858 23.606C22.4107 24.0828 22.6296 24.5622 22.8435 25.0437C18.9084 26.4527 10.5055 29.9674 10.5055 37.1297C10.5055 41.4168 14.097 43.1414 17.2978 43.8278ZM29.1018 43.2164L30.7236 35.8699C31.138 33.7964 32.1571 31.892 33.6523 30.3968L36.6943 27.3547C35.395 27.2366 34.0548 27.6745 33.0602 28.6691L27.81 33.9193C26.3148 35.4145 25.2958 37.3189 24.8813 39.3924L23.9083 44.2607C23.9083 44.2607 28.9938 43.2414 29.1018 43.2164Z"
          fill="currentColor"
        />
        <path
          d="M44.151 24.0171C42.9664 22.8325 41.3914 22.1802 39.7162 22.1802C38.0409 22.1802 36.4659 22.8325 35.2813 24.0171L26.5945 32.7039C24.8536 34.4449 23.6785 36.6412 23.1959 39.0553L22.2228 43.9236C22.1102 44.4869 22.2866 45.0692 22.6928 45.4755C23.0182 45.8008 23.4567 45.9787 23.9079 45.9787C24.0199 45.9787 24.1326 45.9678 24.2447 45.9453L29.113 44.9723C31.5271 44.4898 33.7233 43.3145 35.4643 41.5736L44.151 32.8868C45.3356 31.7022 45.9881 30.1272 45.9881 28.452C45.9881 26.7767 45.3356 25.2017 44.151 24.0171ZM41.7209 30.4567L33.0341 39.1435C31.7747 40.403 30.1859 41.2533 28.4394 41.6022L26.0979 42.0702L26.5659 39.7288C26.915 37.9823 27.7651 36.3935 29.0246 35.134L37.7114 26.4472C38.2469 25.9117 38.9589 25.6168 39.7162 25.6168C40.4734 25.6168 41.1855 25.9117 41.721 26.4472C42.2564 26.9827 42.5514 27.6947 42.5514 28.452C42.5514 29.2092 42.2565 29.9213 41.7209 30.4567Z"
          fill="currentColor"
        />
        <path
          d="M20.545 25.9003C20.0436 26.058 19.535 26.2202 19.238 26.3224C16.2283 27.3588 7.06942 30.5125 7.06942 37.1295C7.06942 38.4088 7.4831 39.4248 8.33418 40.2353C10.5699 42.3648 15.3125 42.6242 16.9496 42.5443C17.8983 42.4971 18.7031 43.2278 18.7505 44.1746C18.798 45.1215 18.0708 45.9278 17.1239 45.9766C17.0738 45.9792 16.8341 45.9902 16.452 45.9902C14.549 45.9902 9.11231 45.7143 5.97211 42.7315C4.41997 41.2572 3.63281 39.3724 3.63281 37.1295C3.63281 34.9612 4.28156 32.9196 5.56084 31.0614C6.58237 29.5779 8.01844 28.2018 9.82953 26.9714C12.9445 24.8549 16.5146 23.6256 18.1942 23.0473C18.5351 22.9298 18.9888 22.7872 19.5141 22.622C21.8606 21.8841 25.7878 20.649 29.1565 18.7732C32.8575 16.7124 34.734 14.5238 34.734 12.2682C34.734 9.69399 33.5144 8.06822 32.4911 7.15769C31.3098 6.10617 29.6946 5.42684 28.3764 5.42684C27.4274 5.42684 26.6581 4.65756 26.6581 3.70854C26.6581 2.75952 27.4274 1.99023 28.3764 1.99023C30.554 1.99023 32.9463 2.96219 34.7758 4.59029C36.965 6.5385 38.1707 9.26519 38.1707 12.2681C38.1707 20.3574 25.8194 24.2416 20.545 25.9003Z"
          fill="currentColor"
        />
        <path
          d="M11.4507 12.6437C7.83201 12.6437 5.62047 11.1071 4.40245 9.81805C2.87573 8.20216 2 5.97532 2 3.70854C2 2.75952 2.76928 1.99023 3.7183 1.99023C4.66732 1.99023 5.43661 2.75952 5.43661 3.70854C5.43661 6.35679 7.31858 9.20711 11.4507 9.20711C14.4195 9.20711 16.2937 7.73315 18.4639 6.02644C19.1366 5.49746 19.832 4.95053 20.5783 4.43658C21.3599 3.89841 22.4298 4.0955 22.9681 4.87707C23.5064 5.65864 23.3092 6.72854 22.5276 7.2668C21.8708 7.71914 21.2478 8.20903 20.5883 8.72779C18.2544 10.5633 15.609 12.6437 11.4507 12.6437Z"
          fill="currentColor"
        />
      </svg>
    ),
  },
  {
    title: 'UI & UX design',
    description: 'The kit is built on the principles of the atomic design system.',
    icon: (
      <svg
        width="48"
        height="48"
        viewBox="0 0 48 48"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          opacity="0.48"
          d="M34.3481 38.3324C32.8525 36.8369 31.8332 34.932 31.4186 32.8579L30.132 25.8482C29.97 25.8078 24.7734 24.7637 24.7734 24.7637L25.7468 29.6332C26.1613 31.7073 27.1806 33.6121 28.6762 35.1077L36.5059 42.9374L37.7295 41.7138L34.3481 38.3324Z"
          fill="currentColor"
        />
        <path
          d="M17.2109 5.42773H12.0169C11.3073 3.42728 9.3969 1.99023 7.15625 1.99023C4.31309 1.99023 2 4.30333 2 7.14648C2 9.38713 3.43705 11.2975 5.4375 12.0071V17.1152C5.4375 18.0645 6.20698 18.834 7.15625 18.834C8.10552 18.834 8.875 18.0645 8.875 17.1152V12.0071C10.3375 11.4884 11.4982 10.3278 12.0169 8.86523H17.2109C18.1602 8.86523 18.9297 8.09575 18.9297 7.14648C18.9297 6.19722 18.1602 5.42773 17.2109 5.42773ZM7.15625 8.86523C6.20853 8.86523 5.4375 8.0942 5.4375 7.14648C5.4375 6.19877 6.20853 5.42773 7.15625 5.42773C8.10397 5.42773 8.875 6.19877 8.875 7.14648C8.875 8.0942 8.10397 8.86523 7.15625 8.86523ZM30.7031 8.86523H35.9831C36.5018 10.3277 37.6624 11.4884 39.125 12.0071V17.1152C39.125 18.0645 39.8945 18.834 40.8438 18.834C41.793 18.834 42.5625 18.0645 42.5625 17.1152V12.0071C44.563 11.2976 46 9.38713 46 7.14648C46 4.30333 43.6869 1.99023 40.8438 1.99023C38.6031 1.99023 36.6927 3.42728 35.9831 5.42773H30.7031C29.7539 5.42773 28.9844 6.19722 28.9844 7.14648C28.9844 8.09575 29.7539 8.86523 30.7031 8.86523ZM40.8438 5.42773C41.7915 5.42773 42.5625 6.19877 42.5625 7.14648C42.5625 8.0942 41.7915 8.86523 40.8438 8.86523C39.896 8.86523 39.125 8.0942 39.125 7.14648C39.125 6.19877 39.896 5.42773 40.8438 5.42773ZM17.2109 39.1152H12.0169C11.4982 37.6528 10.3376 36.4921 8.875 35.9734V30.7793C8.875 29.83 8.10552 29.0605 7.15625 29.0605C6.20698 29.0605 5.4375 29.83 5.4375 30.7793V35.9734C3.43705 36.6829 2 38.5933 2 40.834C2 43.6771 4.31309 45.9902 7.15625 45.9902C9.3969 45.9902 11.3073 44.5532 12.0169 42.5527H17.2109C18.1602 42.5527 18.9297 41.7833 18.9297 40.834C18.9297 39.8847 18.1602 39.1152 17.2109 39.1152ZM7.15625 42.5527C6.20853 42.5527 5.4375 41.7817 5.4375 40.834C5.4375 39.8863 6.20853 39.1152 7.15625 39.1152C8.10397 39.1152 8.875 39.8863 8.875 40.834C8.875 41.7817 8.10397 42.5527 7.15625 42.5527Z"
          fill="currentColor"
        />
        <path
          d="M36.3329 27.4511C34.5915 25.7096 32.3946 24.5342 29.9799 24.0515L25.1103 23.0782C24.547 22.9653 23.9645 23.1418 23.5581 23.5482C23.1518 23.9546 22.9755 24.537 23.088 25.1005L24.0614 29.9701C24.5441 32.3849 25.7196 34.5817 27.4609 36.3231L35.2906 44.1527C36.4755 45.3376 38.0509 45.9902 39.7266 45.9902C41.4023 45.9902 42.9777 45.3376 44.1626 44.1527C45.3475 42.9678 46 41.3924 46 39.7168C46 38.0411 45.3475 36.4657 44.1626 35.2808L36.3329 27.4511ZM41.7318 41.7221C41.1963 42.2577 40.484 42.5527 39.7266 42.5527C38.9691 42.5527 38.2569 42.2577 37.7213 41.722L29.8916 33.8924C28.6319 32.6326 27.7814 31.0434 27.4323 29.2964L26.9642 26.9544L29.3062 27.4225C31.0532 27.7716 32.6425 28.622 33.9022 29.8818L41.7319 37.7115C42.2675 38.2471 42.5625 38.9593 42.5625 39.7168C42.5625 40.4742 42.2675 41.1865 41.7318 41.7221Z"
          fill="currentColor"
        />
        <path
          d="M26.0625 7.14648C26.0625 8.33302 25.1006 9.29492 23.9141 9.29492C22.7275 9.29492 21.7656 8.33302 21.7656 7.14648C21.7656 5.95995 22.7275 4.99805 23.9141 4.99805C25.1006 4.99805 26.0625 5.95995 26.0625 7.14648ZM23.9141 38.6855C22.7275 38.6855 21.7656 39.6474 21.7656 40.834C21.7656 42.0205 22.7275 42.9824 23.9141 42.9824C25.1006 42.9824 26.0625 42.0205 26.0625 40.834C26.0625 39.6474 25.1006 38.6855 23.9141 38.6855ZM40.8438 22.0137C39.6572 22.0137 38.6953 22.9756 38.6953 24.1621C38.6953 25.3486 39.6572 26.3105 40.8438 26.3105C42.0303 26.3105 42.9922 25.3486 42.9922 24.1621C42.9922 22.9756 42.0303 22.0137 40.8438 22.0137ZM7.15625 22.0137C5.96971 22.0137 5.00781 22.9756 5.00781 24.1621C5.00781 25.3486 5.96971 26.3105 7.15625 26.3105C8.34279 26.3105 9.30469 25.3486 9.30469 24.1621C9.30469 22.9756 8.34279 22.0137 7.15625 22.0137Z"
          fill="currentColor"
        />
      </svg>
    ),
  },
  {
    title: 'Development',
    description: 'Easy to customize and extend, saving you time and money.',
    icon: (
      <svg
        width="48"
        height="48"
        viewBox="0 0 48 48"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          opacity="0.48"
          d="M9.04688 27.4V13.2992C9.04688 8.55495 12.8835 4.70898 17.6162 4.70898H12.3984C7.6522 4.70898 3.80469 8.55649 3.80469 13.3027V27.3965C3.80469 32.1426 7.6522 35.9902 12.3984 35.9902H17.6162C12.8835 35.9902 9.04688 32.1443 9.04688 27.4Z"
          fill="currentColor"
        />
        <path
          d="M32.25 44.584H15.75C13.472 44.4995 13.4737 41.2302 15.75 41.1465H32.25C34.528 41.231 34.5263 44.5003 32.25 44.584ZM35.6875 37.709H12.3107C6.62541 37.709 2 33.0837 2 27.3983V13.3027C2 7.61642 6.62619 2.99023 12.3125 2.99023H35.6875C41.3738 2.99023 46 7.61642 46 13.3027V27.3965C46 33.0828 41.3738 37.709 35.6875 37.709ZM12.3125 6.42773C8.52163 6.42773 5.4375 9.51186 5.4375 13.3027V27.3983C5.4375 31.1881 8.52085 34.2715 12.3107 34.2715H35.6875C39.4784 34.2715 42.5625 31.1874 42.5625 27.3965V13.3027C42.5625 9.51186 39.4784 6.42773 35.6875 6.42773H12.3125Z"
          fill="currentColor"
        />
        <path
          d="M22.1107 29.0297C21.9535 29.0297 21.7937 29.008 21.635 28.9624C20.7227 28.7001 20.1958 27.748 20.4581 26.8357L24.4112 13.0857C24.6735 12.1734 25.6258 11.6469 26.538 11.9088C27.4502 12.1711 27.9772 13.1232 27.7149 14.0355L23.7618 27.7855C23.545 28.539 22.8575 29.0297 22.1107 29.0297ZM32.4224 27.3106C31.978 27.3106 31.5338 27.1393 31.1974 26.7974C30.5316 26.1208 30.5402 25.0326 31.2168 24.3668L34.5819 21.0551C34.9162 20.6941 34.9163 20.2198 34.5791 19.8587L31.2086 16.4961C30.5365 15.8256 30.5353 14.7374 31.2057 14.0654C31.8762 13.3933 32.9645 13.3922 33.6364 14.0625L37.0066 17.4247C38.6751 19.0208 38.6751 21.8961 37.0062 23.4922C37.0036 23.4948 37.0009 23.4975 36.9983 23.5001L33.6281 26.8169C33.2933 27.1462 32.8577 27.3106 32.4224 27.3106ZM15.7504 27.3106C15.3151 27.3106 14.8797 27.1462 14.5449 26.8168L11.1747 23.5C11.172 23.4974 11.1693 23.4948 11.1668 23.4921C9.49776 21.8956 9.49784 19.0207 11.1668 17.4244L14.5365 14.0625C15.2086 13.3921 16.2968 13.3935 16.9672 14.0654C17.6376 14.7374 17.6364 15.8256 16.9644 16.4961L13.5941 19.8583C13.2569 20.2193 13.2562 20.6934 13.591 21.0551L16.956 24.3668C17.6326 25.0326 17.6413 26.1208 16.9754 26.7974C16.6391 27.1392 16.1948 27.3106 15.7504 27.3106Z"
          fill="currentColor"
        />
      </svg>
    ),
  },
];
