import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import { isEmpty } from 'lodash';
import queryKey from 'src/sections/bupot-21-26/constant/queryKey';
import { FG_FASILITAS_PPH_21, FG_PERHITUNGAN, KELAMIN } from '../../constant';
import type { TPostTahunanA1Request } from '../types/types';
import tahunanA1Api from '../utils/api';
import { formatDate } from '../utils/formatDate';

const extractKapFromKodeObjekPajak = (kodeObjekPajak: string) =>
  `4111${kodeObjekPajak.split('-')[0]}`;

export const extractKjsFromKodeObjekPajak = (kodeObjekPajak: string) =>
  kodeObjekPajak.split('-')[1];

const transformParams = ({ isPengganti = false, ...Data }: any): TPostTahunanA1Request => {
  const { revNo: initialRevNo, statusPtkp } = Data;

  const revNo = isPengganti ? parseInt(initialRevNo || 0, 10) + 1 : parseInt(initialRevNo || 0, 10);
  const [status, jmlPtkp] = statusPtkp.split('/');

  const npwpLog = localStorage.getItem('npwp_log') ?? '';

  return {
    ...Data,
    revNo,
    noBupot: Data.noBupot || null,
    idBupot: Data.idBupot || null,
    fgTransaction: Data.fgTransaction,
    npwpPemotong: Data.npwpPemotong || npwpLog,
    idTku: Data.idTku,
    masaPajakAwal: formatDate(Data.masaPajakAwal, 'MM'),
    masaPajakAkhir: formatDate(Data.masaPajakAkhir, 'MM'),
    tahunPajak: Data.tahunPajak,
    fgNpwpNik: true,
    npwp: Data.npwp,
    nik: Data.nitku,
    nama: Data.nama,
    alamat: Data.alamat,
    email: Data.email,
    cc_email: Data.cc_email,
    jnsKelamin: Data.optJnsKelamin.value === KELAMIN.LAKI ? 'M' : 'F',
    statusPtkp: status,
    jmlPtkp,
    nominalPtkp: Data.rincian16,
    kodeObjekPajak: Data.kdObjPjk,
    pasalPPh: 'PPh Pasal 21',
    kap: extractKapFromKodeObjekPajak(Data.kdObjPjk),
    kjs: extractKjsFromKodeObjekPajak(Data.kdObjPjk),
    fgStatusPemotonganPph: `${Data.metodePemotongan}`,
    blnPenghasilanDisetahunkan:
      Number(formatDate(Data.masaPajakAkhir, 'MM')) -
      Number(formatDate(Data.masaPajakAwal, 'MM')) +
      1,
    fgJnsBupot: 'A1',
    dataDetilBupotA1: {
      fgKaryawanAsing: Data.fgKaryawanAsing,
      passport: isEmpty(Data.passport) ? null : Data.passport,
      kdNegara: !Data.fgKaryawanAsing ? 'IDN' : Data.kodeNegara,
      posisiJabatan: Data.namaJabatan,
      gajiPensiun: Data.rincian1,
      tunjanganPPh: Data.rincian2,
      tunjanganPPhGrossUp: Data.fgPerhitungan === FG_PERHITUNGAN.GROSS_UP ? 'YES' : 'NO',
      tunjanganLainnyaLembur: Data.rincian3,
      honorarium: Data.rincian4,
      premiAsuransi: Data.rincian5,
      natura: Data.rincian6,
      tantiemBonus: Data.rincian7,
      biayaJabatan: Data.rincian9,
      iuranPensiun: Data.rincian10,
      zakat: Data.rincian11,
      fgFasilitas: Data.fgFasilitas === FG_FASILITAS_PPH_21.DTP ? '11' : Data.fgFasilitas,
      noDokFasilitas: Data.noDokFasilitas,
    },
    totalPenghasilanBruto: Data.rincian8,
    totalPengurang: Data.rincian12,
    totalPenghasilanNeto: Data.rincian13,
    noBupotSebelumnya: Data.noBupotSebelumnya || null,
    totalPenghasilanNetoDariBupotSebelumnya: Data.rincian14,
    totalPenghasilanNetoPph21: Data.rincian15,
    pkpSetahunDisetahunkan: Data.rincian17,
    pph21SetahunDisetahunkan: Data.rincian18,
    pph21Terutang: Data.rincian19,
    pph21DariBupotSebelumnya: Data.rincian20,
    pph21DapatDikreditkan: Data.rincian21,
    pph21WithheldDtp: Data.rincian22,
    pph21KurangLebihBayar: Data.rincian23,
    tglPemotongan: !isEmpty(Data?.tglPemotongan)
      ? formatDate(Data?.tglPemotongan, 'DDMMYYYY')
      : formatDate(new Date(), 'DDMMYYYY'),
    userId: Data.userId,
    kanal: '14',
  };
};

const useSaveTahunanA1 = (
  props?: Omit<UseMutationOptions<any, Error, any, unknown>, 'mutationKey' | 'mutationFn'>
) =>
  useMutation({
    mutationKey: queryKey.tahunanA1.draft,
    mutationFn: (params: any) => tahunanA1Api.save(transformParams(params)),
    ...props,
  });

export default useSaveTahunanA1;
