import type { FC } from 'react';
import { Box, Button, Card, CardContent, CardHeader, IconButton, Typography } from '@mui/material';
import { ChevronRightRounded, CloseRounded } from '@mui/icons-material';
import { m } from 'framer-motion';
import { PANDUAN_REKAM_NR } from '../../constant';

interface PanduanDokumenDipersamakanRekamProps {
  handleOpen: () => void;
  isOpen: boolean;
}

const PanduanDokumenDipersamakanRekam: FC<PanduanDokumenDipersamakanRekamProps> = ({
  handleOpen,
  isOpen,
}) => (
    <Box position="sticky">
      {/* Tombol toggle */}
      <Box
        height="100%"
        display={isOpen ? 'none' : 'flex'}
        justifyContent="center"
        alignItems="center"
      >
        <Button
          variant="contained"
          sx={{
            height: 'fit-content',
            right: 0,
            borderRadius: 0,
            minWidth: 35,
            pt: 3,
            pb: 3,
            fontWeight: 'bold',
            fontSize: 16,
            backgroundColor: '#143B88',
          }}
          size="small"
          onClick={handleOpen}
        >
          <span
            style={{
              writingMode: 'vertical-rl',
              transform: 'rotate(180deg)',
              display: 'flex',
              alignItems: 'center',
            }}
          >
            Panduan Penggunaan
            <ChevronRightRounded sx={{ fontSize: 30 }} />
          </span>
        </Button>
      </Box>

      {/* Konten panduan */}
      {isOpen && (
        <m.div
          initial={{ x: 20, opacity: 0 }}
          animate={{ x: 0, opacity: 1, transition: { delay: 0.2 } }}
        >
          <Card>
            <CardHeader
              avatar={
                <img src="/assets/icon_panduan_penggunaan_1.svg" alt="Panduan" loading="lazy" />
              }
              sx={{
                backgroundColor: '#123375',
                color: '#FFFFFF',
                padding: '16px',
                '& .MuiCardHeader-title': {
                  fontSize: 18,
                },
              }}
              action={
                <IconButton aria-label="close" onClick={handleOpen} sx={{ color: 'white' }}>
                  <CloseRounded />
                </IconButton>
              }
              title="Panduan Penggunaan"
            />
            <CardContent
              sx={{
                maxHeight: 300,
                overflow: 'auto',
                '&::-webkit-scrollbar': { width: 6 },
                '&::-webkit-scrollbar-track': { backgroundColor: '#f0f0f0', borderRadius: 8 },
                '&::-webkit-scrollbar-thumb': { backgroundColor: '#123375', borderRadius: 8 },
                '&::-webkit-scrollbar-thumb:hover': { backgroundColor: '#0d2858' },
                scrollbarWidth: 'thin',
                scrollbarColor: '#123375 #f0f0f0',
              }}
            >
              {/* Deskripsi Form */}
              <Typography variant="body2" sx={{ mb: 2, whiteSpace: 'pre-line' }}>
                <span style={{ fontWeight: 600 }}>Deskripsi Form:</span>
                <br />
                {PANDUAN_REKAM_NR.description.intro}
              </Typography>

              <Typography variant="body2" sx={{}}>
                {PANDUAN_REKAM_NR.description.textList}
              </Typography>
              <Box component="ol" sx={{ pl: 3, mb: 2 }}>
                {PANDUAN_REKAM_NR.description.list.map((item, idx) => (
                  <Typography key={idx} variant="body2" component="li">
                    {item}
                  </Typography>
                ))}
              </Box>

              <Typography variant="body2" sx={{ mb: 2 }}>
                {PANDUAN_REKAM_NR.description.closing}
              </Typography>

              {/* Bagian-bagian */}
              {PANDUAN_REKAM_NR.sections.map((section, i) => (
                <Box key={i} sx={{ mb: 2 }}>
                  <Typography
                    variant="body2"
                    sx={{ fontWeight: 'bold', fontSize: '0.95rem', mb: 0.5 }}
                  >
                    {section.title}
                  </Typography>

                  <Box component="ul" sx={{ pl: 2, listStyle: 'disc' }}>
                    {section.items.map((item, idx) => (
                      <Box key={idx} component="li" sx={{ mb: 0.5 }}>
                        <Typography variant="body2" component="span">
                          {item.text}
                        </Typography>

                        {item.subItems.length > 0 && (
                          <Box component="ol" sx={{ pl: 3, listStyle: 'decimal' }}>
                            {item.subItems.map((sub, subIdx) => (
                              <Typography key={subIdx} variant="body2" component="li">
                                {sub}
                              </Typography>
                            ))}
                          </Box>
                        )}
                      </Box>
                    ))}
                  </Box>
                </Box>
              ))}
            </CardContent>
          </Card>
        </m.div>
      )}
    </Box>
  );

export default PanduanDokumenDipersamakanRekam;
