import { useQuery } from '@tanstack/react-query';
import type { TCountryResult } from '../types/types';
import nrApi from '../utils/api';

export const useGetNegara = (params?: Record<string, any>) =>
  useQuery<TCountryResult>({
    queryKey: ['negara-nr'],
    queryFn: async () => {
      const res = await nrApi.getCountryNr(params);
      return res.data; // ✅ langsung array negara
    },
  });

export default useGetNegara;
