import { Grid, Skeleton } from '@mui/material';

function FormSkeleton({ numberOfRows = 5 }) {
  return (
    <Grid container spacing={2}>
      {[...Array(numberOfRows)].map((_, index) => (
        <>
          <Grid size={{ md: 6 }} key={index}>
            <Skeleton
              variant="rounded"
              sx={{
                width: '100%',
                height: 50,
              }}
            />
          </Grid>
          <Grid size={{ md: 6 }} key={index}>
            <Skeleton
              variant="rounded"
              sx={{
                width: '100%',
                height: 50,
              }}
            />
          </Grid>
        </>
      ))}
    </Grid>
  );
}

export default FormSkeleton;
