import { Grid } from '@mui/material';
import { Field } from 'src/components/hook-form';
import {
  FG_FASILITAS_PPH_21,
  FG_PERHITUNGAN,
  FG_PERHITUNGAN_TEXT,
  KODE_OBJEK_PAJAK,
  PTKP,
  PTKP_TEXT,
  PTKP_TITLE,
} from '../../constant';
import { useMemo } from 'react';
import { RHFNumeric } from 'src/components/hook-form/rhf-numeric';
import { useFormContext } from 'react-hook-form';
import { LoadingButton } from '@mui/lab';
import { CalculateRounded } from '@mui/icons-material';

const fgPerhitunganOptions = Object.values(FG_PERHITUNGAN).map((value) => ({
  value,
  label: FG_PERHITUNGAN_TEXT[value],
}));

function JumlahPerhitunganForm() {
  const { watch } = useFormContext();

  const fgFasilitas = watch('fgFasilitas');
  const ptkpOptions = useMemo(
    () =>
      Object.entries(PTKP)
        .map(([key, value]) => ({ value, label: PTKP_TEXT[value] }))
        .filter((option) => !option.value.includes(PTKP_TITLE.HB)),
    []
  );
  return (
    <Grid container rowSpacing={2} columnSpacing={2} sx={{ my: 3 }}>
      <Grid size={{ md: 3 }}>
        <Field.RadioGroup
          row
          name="fgPerhitungan"
          label="Metode Pemotongan"
          options={fgPerhitunganOptions.filter((a) => a.value !== FG_PERHITUNGAN.MIXED)}
        />
      </Grid>

      <Grid size={{ md: 9 }}>
        <Field.Autocomplete name="ptkp" label="Status PTKP" options={ptkpOptions} />
      </Grid>

      <Grid size={{ md: 6 }}>
        <RHFNumeric name="phBruto" label="Jumlah Penghasilan (Rp)" />
      </Grid>

      <Grid size={{ md: 6 }}>
        <RHFNumeric name="tunjanganPPh" label="Tunjangan PPh 21 (Rp)" />
      </Grid>

      <Grid size={{ md: 5 }}>
        <RHFNumeric
          name="tarif"
          label="Tarif (%)"
          allowDecimalValue
          maxValue={100}
          readOnly={
            ![
              KODE_OBJEK_PAJAK.FINAL_38,
              KODE_OBJEK_PAJAK.FINAL_99,
              KODE_OBJEK_PAJAK.TIDAK_FINAL_99,
            ].includes(watch('kodeObjekPajak')) &&
            ![FG_FASILITAS_PPH_21.FASILITAS_LAINNYA].includes(watch('fgFasilitas'))
          }
        />
      </Grid>

      <Grid size={{ md: 5 }}>
        <RHFNumeric
          name="pph21"
          label="PPh Pasal 21"
          readOnly={![KODE_OBJEK_PAJAK.FINAL_38].includes(watch('kodeObjekPajak'))}
        />
      </Grid>

      <Grid size={{ md: 2 }} alignSelf="center">
        <LoadingButton
          variant="contained"
          fullWidth
          size="large"
          color="primary"
          // onClick={handleHitung}
          // loading={hitung.isLoading}
          startIcon={<CalculateRounded />}
        >
          Hitung
        </LoadingButton>
      </Grid>
    </Grid>
  );
}

export default JumlahPerhitunganForm;
