import {
  FG_PERHITUNGAN,
  KODE_OBJEK_PAJAK,
  PERHITUNGAN_BUPOT21,
} from 'src/sections/bupot-21-26/constant';

export type paramsHitung = {
  kodeObjekPajak: string;
  fgPerhitungan: string;
  jenisPerhitungan: string;
  phBruto: number;
};

export const checkPerhitunganBupot21 = ({
  kodeObjekPajak,
  fgPerhitungan
}: paramsHitung) => {
  switch (kodeObjekPajak) {
    case KODE_OBJEK_PAJAK.BULANAN_01:
    case KODE_OBJEK_PAJAK.BULANAN_02:
    case KODE_OBJEK_PAJAK.BULANAN_03:
      if (fgPerhitungan == FG_PERHITUNGAN.GROSS) return PERHITUNGAN_BUPOT21.BULANAN_GROSS;
      if (fgPerhitungan == FG_PERHITUNGAN.GROSS_UP) return PERHITUNGAN_BUPOT21.BULANAN_GROSS_UP;
      if (fgPerhitungan == FG_PERHITUNGAN.MIXED) return PERHITUNGAN_BUPOT21.BULANAN_MIXED;
      return null;
    default:
      return null;
  }
};
