import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import dayjs from 'dayjs';
import queryKey from 'src/sections/bupot-21-26/constant/queryKey';
import { FG_FASILITAS_PPH_21 } from '../../constant';
import type { TPostBupotFinalRequest } from '../types/types';
import bupotFinalTdkFinalApi from '../utils/api';

const transformParams = ({ isPengganti = false, ...Data }: any): TPostBupotFinalRequest => {
  const {
    id,
    idBupot,
    noBupot,
    masaPajak,
    tahunPajak,
    npwp,
    nitku,
    namaDipotong,
    fgFasilitas,
    noDokLainnya,
    kdObjPjk,
    phBruto,
    pasalPPh,
    tarif,
    pphDipotong,
    revNo: initialRevNo,
    tglPemotongan,
    idTku,
    fgGrossUp,
    alamatDipotong,
    statusPtkp,
    dppPersen,
    kap,
    kjs,
    akumulasiJmlBruto,
    namaDokumenReferensi,
    nomorDokumenReferensi,
    tanggalDokumenReferensi,
    tunjanganPPh
  } = Data;

  const revNo = isPengganti ? parseInt(initialRevNo || 0, 10) + 1 : parseInt(initialRevNo || 0, 10);

  const npwpLog = localStorage.getItem('npwp_log') ?? '';

  return {
    id: !isPengganti ? (id ?? null) : null,
    revNo,
    idBupot,
    noBupot,
    npwpPemotong: npwpLog,
    idTku: idTku ?? '',
    masaPajak,
    tahunPajak,
    fgTransaction: id ? 'EDIT' : 'NEW',
    fgNpwpNik: true,
    npwp,
    nik: nitku,
    nama: namaDipotong ?? '',
    fgGrossUp: fgGrossUp ?? 1,
    fgJnsBupot: '21',
    alamat: alamatDipotong ?? '',
    dataDetilBp21: {
      sertifikatInsentifDipotong: fgFasilitas ?? '9',
      nomorSertifikatInsentif: noDokLainnya ?? '',
      kodeObjekPajak: kdObjPjk ?? '',
      pasalPPh,
      statusPPh: statusPtkp,
      kap,
      kjs,
      penghasilanKotorSebelumnya: akumulasiJmlBruto || '0',
      penghasilanKotor: phBruto ?? 0,
      tarif: [FG_FASILITAS_PPH_21.SKB_PPH_PASAL_21].includes(fgFasilitas) ? 0 : (tarif ?? 0),
      pphDipotong: pphDipotong ?? 0,
      tunjanganPPh,
      NormaPenghasilan: Number(dppPersen || 50),
      dokReferensi: [
        {
          dokReferensi: namaDokumenReferensi,
          nomorDokumen: nomorDokumenReferensi,
          tanggal_Dokumen: dayjs(tanggalDokumenReferensi).format('DDMMYYYY'),
        },
      ],
    },
    tglPemotongan: tglPemotongan ? dayjs(tglPemotongan).format('DDMMYYYY') : '',
    feature: 'final',
    kanal: '14',
  };
};

const useSaveBupotFnlTdkFnl = (
  props?: Omit<UseMutationOptions<any, Error, any, unknown>, 'mutationKey' | 'mutationFn'>
) =>
  useMutation({
    mutationKey: queryKey.bulanan.draft,
    mutationFn: (params: any) => bupotFinalTdkFinalApi.save(transformParams(params)),
    ...props,
  });

export default useSaveBupotFnlTdkFnl;
