import Divider from '@mui/material/Divider';
import Grid from '@mui/material/Grid';
import MenuItem from '@mui/material/MenuItem';
import { Field } from 'src/components/hook-form';
import { JENIS_DOKUMEN } from 'src/sections/bupot-unifikasi/bupot-dn/constant';

const DokumenReferensi = () => {
  const MockNitku = [
    {
      nama: '1091031210912281000000',
    },
    {
      nama: '1091031210912281000001',
    },
  ];
  return (
    <Grid sx={{ mb: 3 }} container rowSpacing={2} columnSpacing={2}>
        <Grid sx={{ mt: 3 }} size={{ md: 12 }}>
          <Divider sx={{ fontWeight: 'bold' }} textAlign="left">
            Daftar Dokumen
          </Divider>
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Select name="namaDok" label="Nama Dokumen">
            {JENIS_DOKUMEN.map((item, index) => (
              <MenuItem key={index} value={item.value}>
                {item.label}
              </MenuItem>
            ))}
          </Field.Select>
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="nomorDok" label="Nomor Dokumen" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.DatePicker name="tglDok" label="Tanggal Dokumen" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Select name="idTku" label="NITKU Pemotong">
            {MockNitku.map((item, index) => (
              <MenuItem key={index} value={item.nama}>
                {item.nama}
              </MenuItem>
            ))}
          </Field.Select>
        </Grid>
      </Grid>
  );
};

export default DokumenReferensi;
