export const Steps = [
  {
    icon: '1',
    label: 'Dokumen Transaksi',
  },
  {
    icon: '2',
    label: 'Lawan Transaksi',
  },
  {
    icon: '3',
    label: 'Detail Transaksi',
  },
];

export const Identitas = {
  NPWP: '4',
  NIK: '1',
  PASSPORT: '2',
  ID_LAIN: '3',
};

export const TransaksiRekamAction = {
  CREATE: 'create',
  UPDATE: 'update',
};

export const identitasOptions = [
  {
    text: 'NPWP',
    value: Identitas.NPWP,
  },
  {
    text: 'NIK',
    value: Identitas.NIK,
  },
  {
    text: 'Passport',
    value: Identitas.PASSPORT,
  },
  {
    text: 'ID Lain',
    value: Identitas.ID_LAIN,
  },
];

export const jenisTransaksiOptions = [
  {
    label: '01 : Kepada pihak lain selain Pemungut PPN',
    id: 'TD.00301',
  },
  {
    label: '02 : kepada Pemungut PPN Instansi Pemerintah',
    id: 'TD.00302',
  },
  {
    label: '03 : kepada Pemungut PPN selain Instansi Pemerintah',
    id: 'TD.00303',
  },
  {
    label: '04 : penyerahan yang menggunakan Dasar Pengenaan Pajak (DPP) Nilai Lain',
    id: 'TD.00304',
  },
  {
    label: '05 : penyerahan yang PPN-nya dipungut dengan besaran tertentu',
    id: 'TD.00305',
  },
  {
    label: '06 : kepada pemegang paspor luar negeri dalam rangka VAT Refund for Tourist',
    id: 'TD.00306',
  },
  {
    label:
      '07 : penyerahan yang mendapat fasilitas PPN dan/atau PPnBM Tidak Dipungut atau Ditanggung Pemerintah',
    id: 'TD.00307',
  },
  {
    label: '08 : penyerahan yang mendapat fasilitas dibebaskan dari pengenaan PPN dan/atau PPnBM',
    id: 'TD.00308',
  },
  {
    label: '09 : penyerahan aktiva yang menurut tujuan semula tidak untuk diperjualbelikan',
    id: 'TD.00309',
  },
  {
    label: '10 : untuk penyerahan lainnya',
    id: 'TD.00310',
  },
];

export const JenisFaktur = (() => ({
  FAKTUR_PAJAK: '0',
  FAKTUR_PAJAK_PENGGANTI: '1',
}))();

export const JenisTransaksi = (() => ({
  KEPADA_PIHAK_YANG_BUKAN_PEMUNGUT: 'TD.00301',
  KEPADA_PEMUNGUT_BENDAHARAWAN: 'TD.00302',
  KEPADA_PEMUNGUT_SELAIN_BEDAHARAWAN: 'TD.00303',
  DPP_NILAI_LAIN: 'TD.00304',
  BESARAN_TERTAENTU: 'TD.00305',
  PENYERAHAN_LAINNYA: 'TD.00306',
  PENYERAHAN_YANG_PPN_TIDAK_DIPUNGUT: 'TD.00307',
  PENYERAHAN_YANG_PPN_DIPUNGUT: 'TD.00308',
  AKTIVA: 'TD.00309',
  TARIF_NORMAL: 'TD.00310',
}))();

export const jenisFakturOptions = [
  {
    label: '0 : Faktur Pajak',
    id: '0',
  },
  {
    label: '1 : Faktur Pajak Pengganti',
    id: '1',
  },
];

export const FgUangMukaInRadioInput = (() => ({
  NORMAL: 0,
  UANG_MUKA: 1,
  PELUNASAN: 2,
}))();

export const FgPengganti = (() => ({
  NORMAL: '0',
  PENGGANTI: '1',
}))();

export const PkRekamActionUbah = (() => ({
  NORMAL: 'normal',
  PENGGANTI: 'pengganti',
}))();

export const PkRekamAction = (() => ({
  REKAM: 'new',
  UBAH: 'ubah',
  PENGGANTI: 'pengganti',
}))();

export const UnitBarangOptions = [
  {
    label: 'g',
    id: '01',
  },
  {
    label: 'Kg',
    id: '02',
  },
  {
    label: 'm',
    id: '03',
  },
  {
    label: 'Km',
    id: '04',
  },
  {
    label: 'Ons',
    id: '05',
  },
];

export const FG_STATUS_DN = {
  DRAFT: 'DRAFT',
  NORMAL_DONE: 'NORMAL-Done',
  AMENDED: 'AMENDED',
  CANCELLED: 'CANCELLED',
};

export const FG_STATUS_FAKTUR_PK = {
  DRAFT: 'DRAFT',
  AMENDED: 'AMENDED',
  CANCELLED: 'CANCELLED',
  APPROVED: 'APPROVED',
  WAITING_FOR_AMENDMENT: 'WAITING FOR AMENDMENT',
  WAITING_FOR_CANCELLATION: 'WAITING FOR CANCELLATION',
};

export const FG_FASILITAS_DN = {
  SKB_PPH_PASAL_22: '1',
  SKB_PPH_PASAL_23: '2',
  SKB_PPH_PHTB: '3',
  DTP: '4',
  SKB_PPH_BUNGA_DEPOSITO_DANA_PENSIUN_TABUNGAN: '5',
  SUKET_PP23_PP52: '6',
  SKD_WPLN: '7',
  FASILITAS_LAINNYA: '8',
  TANPA_FASILITAS: '9',
  SKB_PPH_PASAL_21: '10',
  DTP_PPH_PASAL_21: '11',
};

export const PANDUAN_REKAM_DIGUNGGUNG = {
  description: {
    intro:
      'Form ini digunakan untuk melakukan perekaman/perubahan data Bukti Setor atas PPh yang disetor sendiri.\n',
    textList: '',
    list: [],
    closing: 'Berikut ini petunjuk pengisian:',
  },

  sections: [
    {
      title: '',
      items: [
        {
          text: 'Jenis Bukti Penyetoran, tentukan dokumen jenis bukti penyetoran.',
          subItems: [],
        },
        {
          text: 'Nomor Bukti Penyetoran/Pemindahbukuan, silakan rekam nomor bukti penyetoran/pemindahbukuan.',
          subItems: [],
        },
        {
          text: 'Tahun dan masa Pajak, jika Anda merekam Bukti Penyetoran, tentukan tahun dan masa pajak saat.',
          subItems: [],
        },
        {
          text: 'Kode Objek Pajak, pilihlah Kode Objek Pajak dari pilihan yang tersedia, Anda dapat mengetikan kata kunci untuk mempercepat pencarian objek pajak.',
          subItems: [],
        },
        {
          text: 'Tanggal Setor, silakan rekam tanggal penyetoran.',
          subItems: [],
        },
        {
          text: 'Isikan nilai nominal Penghasilan Bruto dan Jumlah Setor pada kotak yang tersedia.',
          subItems: [],
        },
        {
          text: 'Pastikan isian Anda telah lengkap dan benar, klik tombol simpan untuk menyimpan data.',
          subItems: [],
        },
      ],
    },
  ],
};

export const JENIS_INVOICE = {
  UANG_MUKA: 'uang-muka',
  PELUNASAN: 'pelunasan',
  FULL_PAYMENT: 'full-payment',
};

export const JENIS_INVOICE_TEXT = {
  [JENIS_INVOICE.UANG_MUKA]: 'Uang Muka',
  [JENIS_INVOICE.PELUNASAN]: 'Pelunasan',
  [JENIS_INVOICE.FULL_PAYMENT]: 'Full Payment',
};

export const MIN_THN_PAJAK = 2022;
