import React from 'react';

import Grid from '@mui/material/Grid';
import Divider from '@mui/material/Divider';
import { RHFNumeric } from 'src/components/hook-form/rhf-numeric';
import Typography from '@mui/material/Typography';

// ----------------------------------------------------------------------
type Props = {
  data?: any | null;
  type?: string;
  isLoading?: boolean;
};

const TotalTransaksiRetur: React.FC<Props> = ({ data = null, isLoading = false, type }) => {
  const formatRupiah = (v: number | null | undefined) =>
    v === null || v === undefined ? '' : new Intl.NumberFormat('id-ID').format(Math.round(v));

  return (
    <Grid container spacing={2} sx={{ mb: 3 }}>
      <Grid size={{ xs: 12 }} sx={{ mt: 3 }}>
        <Divider sx={{ fontWeight: 'bold', fontSize: '1rem', mb: 2 }} textAlign="left">
          Total Transaksi Retur
        </Divider>
      </Grid>

      <Grid size={{ md: 4 }}>
        <RHFNumeric
          name="nilaiReturJmlBrg"
          label="Total Retur Jumlah Barang"
          allowDecimalValue
          decimalScale={2}
          displayOnly
        />
      </Grid>
      <Grid size={{ md: 4 }}>
        <RHFNumeric
          name="nilaiRetur"
          label="Total Harga Retur"
          allowDecimalValue
          decimalScale={2}
          displayOnly
        />
      </Grid>
      <Grid size={{ md: 4 }}>
        <RHFNumeric
          name="nilaiReturDiskon"
          label="Total Retur Diskon"
          allowDecimalValue
          decimalScale={2}
          displayOnly
        />
      </Grid>

      <Grid size={{ md: 3 }}>
        <RHFNumeric
          name="nilaiReturDpp"
          label="Total Retur DPP (Rp)"
          allowDecimalValue
          decimalScale={2}
          displayOnly
        />
        <Typography variant="caption" color="text.secondary" sx={{ display: 'block', mt: 1 }}>
          Max Total DPP:{' '}
          {type === 'retur' ? formatRupiah(data.maxTotalDpp) : formatRupiah(data.returMaxDpp)}
        </Typography>
      </Grid>
      <Grid size={{ md: 3 }}>
        <RHFNumeric
          name="nilaiReturDppLain"
          label="Total Retur DPP Nilai Lain (Rp)"
          allowDecimalValue
          decimalScale={2}
          displayOnly
        />
        <Typography variant="caption" color="text.secondary" sx={{ display: 'block', mt: 1 }}>
          Max Total DPP Nilai Lain:{' '}
          {type === 'retur'
            ? formatRupiah(data.maxTotalDppLain)
            : formatRupiah(data.returMaxDppLain)}
        </Typography>
      </Grid>
      <Grid size={{ md: 3 }}>
        <RHFNumeric
          name="nilaiReturPpn"
          label="Total Retur PPN (Rp)"
          allowDecimalValue
          decimalScale={2}
          displayOnly
        />
        <Typography variant="caption" color="text.secondary" sx={{ display: 'block', mt: 1 }}>
          Max Total PPN:{' '}
          {type === 'retur' ? formatRupiah(data.maxTotalPpn) : formatRupiah(data.returMaxPpn)}
        </Typography>
      </Grid>
      <Grid size={{ md: 3 }}>
        <RHFNumeric
          name="nilaireturppnbm"
          label="Total Retur PPnBM (Rp)"
          allowDecimalValue
          decimalScale={2}
          displayOnly
        />
        <Typography variant="caption" color="text.secondary" sx={{ display: 'block', mt: 1 }}>
          Max Total PPnBM:{' '}
          {type === 'retur' ? formatRupiah(data.maxTotalPpnbm) : formatRupiah(data.returMaxPpnbm)}
        </Typography>
      </Grid>
    </Grid>
  );
};

export default TotalTransaksiRetur;
