import { useQuery } from '@tanstack/react-query';
import queryKey from '../constant/queryKey';
import fakturApi from '../utils/api';
import type { TDetailUangMuka } from '../types/types';

export const useGetDetailUangMuka = (nomorFaktur: string, options = {}) =>
  useQuery<TDetailUangMuka>({
    queryKey: queryKey.faktuPK.uangMukaDetail(nomorFaktur),
    queryFn: async () => {
      const res = await fakturApi.getDetailUangMuka(nomorFaktur);
      if (!res) throw new Error('Data tidak ditemukan');
      return res;
    },
    enabled: !!nomorFaktur,
    refetchOnWindowFocus: false,
    ...options,
  });

export default useGetDetailUangMuka;
