import React from 'react';
import Chip from '@mui/material/Chip';
import Box from '@mui/material/Box';
import { HourglassTopRounded } from '@mui/icons-material';
import { IconButton, Tooltip } from '@mui/material';

type Props = {
  value?: string;
  revNo?: number;
  valid?: string;
  credit?: string | null;
};

const StatusChip: React.FC<Props> = ({ value, credit, valid }) => {
  if (!value) return <Chip label="" size="small" />;

  let mainComponent: React.ReactNode = <Chip label={value} size="small" />;

  const componentCredit = (() => {
    if (credit === 'UNCREDITED') {
      return (
        <Chip
          label="UNCREDITED"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#d32f2f',
            color: '#d32f2f',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    } else if (credit === 'CREDITED') {
      return (
        <Chip
          label="CREDITED"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    } else if (credit === null) {
      return (
        <Chip
          label="Belum diKreditkan"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    }

    return null;
  })();

  if (value === 'WAITING FOR AMENDMENT') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Normal Pengganti"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Tooltip title="Menunggu Persetujuan">
          <IconButton
            size="small"
            sx={{
              backgroundColor: 'orange',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: 'orange',
              },
            }}
          >
            <HourglassTopRounded style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      </Box>
    );
  } else if (value === 'APPROVED') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Normal"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Chip
          label="Approved"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      </Box>
    );
  } else if (value === 'CANCELLED') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Batal"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#d32f2f',
            color: '#d32f2f',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Chip
          label="Approved"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      </Box>
    );
  } else if (value === 'DRAFT') {
    mainComponent = (
      <Chip
        label="Draft"
        size="small"
        variant="outlined"
        sx={{
          borderColor: '#9e9e9e',
          color: '#616161',
          borderRadius: '8px',
        }}
      />
    );
  }

  // ✅ Gabungkan komponen utama + tambahan
  return (
    <Box
      sx={{
        display: 'inline-flex',
        alignItems: 'center',
        gap: '8px',
      }}
    >
      {mainComponent}
      {componentCredit}
    </Box>
  );
};

export default React.memo(StatusChip);
