import { useMutation } from '@tanstack/react-query';
import fakturApi from '../utils/api';
import type { TPostReturPMRequest, TBaseResponseAPI } from '../types/types';

type TPostReturPMResponse = TBaseResponseAPI<{
  id: string;
  nomorRetur: string;
}>;

const usePostReturPM = (props?: any) =>
  useMutation<TPostReturPMResponse, Error, TPostReturPMRequest>({
    mutationKey: ['create-retur-pm'],
    mutationFn: (payload) => fakturApi.postReturPM(payload),
    ...props,
  });

export default usePostReturPM;
