import Divider from '@mui/material/Divider';
import Grid from '@mui/material/Grid';
import { useCallback } from 'react';
import { useFormContext } from 'react-hook-form';
import { Field } from 'src/components/hook-form';
import {
  FG_FASILITAS_MASTER_KEY,
  FG_FASILITAS_PPH_21,
  FG_FASILITAS_PPH_21_TEXT,
} from 'src/sections/bupot-21-26/constant';

type PPHDipotongProps = {
  kodeObjectPajak: {
    value: string;
    label: string;
  }[];
  fgFasilitasOptions: {
    value: string;
    label: string;
  }[];
};

const PerhitunganPPhPasal21 = ({ kodeObjectPajak, fgFasilitasOptions }: PPHDipotongProps) => {
  const { watch, setValue } = useFormContext();

  const fgFasilitas = watch('fgFasilitas');
  const kdObjPjk = watch('kdObjPjk');

  const handleChangeKodeObjekPajak = (value: any) => {
    [
      { key: 'jenisHitung', value: value?.jenisHitung || '' },
      { key: 'dppPersen', value: value?.dpp || '' },
      { key: 'pasalPPh', value: value?.pasal || '' },
      { key: 'statusPph', value: value?.statuspph || '' },
      { key: 'kap', value: value?.kap || '' },
      { key: 'kjs', value: value?.kjs || '' },

      //reset value
      {
        key: 'fgFasilitas',
        value: {
          value: FG_FASILITAS_PPH_21.TANPA_FASILITAS,
          label: FG_FASILITAS_PPH_21_TEXT[FG_FASILITAS_PPH_21.TANPA_FASILITAS],
        },
      },
      { key: 'jenisPerhitungan', value: '' },
      { key: 'fgPerhitungan', value: '0' },
      { key: 'tunjanganPPh', value: 0 },
      { key: 'tarif', value: 0 },
      { key: 'pph21', value: 0 },
      { key: 'akumulasiJmlBruto', value: 0 },
    ].forEach(({ key, value: val }) => {
      setValue(key, val);
    });
  };

  const filterFgFasilitasOptions = useCallback(
    (options: any[]) =>
      options?.filter((item) => kdObjPjk[FG_FASILITAS_MASTER_KEY[item.value]] === 1),
    [kdObjPjk]
  );

  return (
    <Grid container rowSpacing={2} columnSpacing={2}>
      {/* Divider */}
      <Grid size={{ md: 12 }}>
        <Divider sx={{ fontWeight: 'bold' }} textAlign="left">
          Perhitungan PPh Pasal 21
        </Divider>
      </Grid>

      {/* Kode objek pajak */}
      <Grid size={{ md: 12 }}>
        <Field.Autocomplete
          name="kdObjPjk"
          label="Kode Objek Pajak"
          options={kodeObjectPajak}
          onChange={(_, value) => {
            setValue('kdObjPjk', value);
            handleChangeKodeObjekPajak(value);
          }}
        />
      </Grid>

      {/* Fasilitas */}
      <Grid size={{ md: 6 }}>
        <Field.Autocomplete
          name="fgFasilitas"
          label="Fasilitas"
          options={filterFgFasilitasOptions(fgFasilitasOptions)}
        />
      </Grid>

      {/* Dokumen lainnya */}
      <Grid size={{ md: 6 }}>
        <Field.Text
          name="noDokLainnya"
          label="Nomor Dokumen Lainnya"
          disabled={['9', ''].includes(fgFasilitas.value)}
          sx={{ '& .MuiInputBase-root.Mui-disabled': { backgroundColor: '#f6f6f6' } }}
        />
      </Grid>
    </Grid>
  );
};

export default PerhitunganPPhPasal21;
