import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import type { TBaseResponseAPI, TValidateFakturPMRequest } from '../types/types';
import fakturApi from '../utils/api';

// Hook menerima UseMutationOptions sehingga pemanggil bisa inject onSuccess/onError dsb.
const useConfirmationWaitingFakturPM = (
  options?: UseMutationOptions<TBaseResponseAPI<null>, Error, TValidateFakturPMRequest>
) =>
  useMutation<TBaseResponseAPI<null>, Error, TValidateFakturPMRequest>({
    mutationKey: ['confirmation-waiting-faktur-pm'],
    mutationFn: (payload) => fakturApi.confirmationWaitingFakturPM(payload),
    ...options,
  });

export default useConfirmationWaitingFakturPM;
