import { useQuery } from '@tanstack/react-query';
import type { TGoodsResult } from '../types/types';
import fakturApi from '../utils/api';

const useGetGoods = (params?: Record<string, any>) =>
  useQuery<TGoodsResult>({
    queryKey: ['goods-faktur-pk'],
    queryFn: async () => {
      const res = await fakturApi.getGoods(params);
      return res.data;
    },
  });

export default useGetGoods;
