export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataDokumenLainMasukan = {
  id: number;
  internal_id: string;

  kdtransaksi: string;
  detailtransaksi: string;
  fgpengganti: string;
  nomordokumendiganti: string;

  masapajak: string;
  tahunpajak: string;
  masacredit: string | null;
  tahuncredit: string | null;

  refdoc: string;
  namapenjual: string;
  npwppenjual: string;
  npwppembeli: string;

  jumlahdpp: string;
  jumlahppn: string;
  jumlahppnbm: string;
  jumlahdpplain: string;

  tanggaldokumen: string;
  tanggaldokumendiganti: string | null;

  userid: string;
  kanal: string | null;

  approvalsign: string | null;
  tanggalapproval: string | null;
  kodeapproval: string | null;

  statusdokumen: string;
  statuspembeli: string;
  buyerstatus: string;

  iscreatedbybuyer: boolean;
  fgbatal: string;

  keterangantambahan: string | null;
  dokumentransaksi: string | null;
  kodedokumen: string | null;
  nomordokumen: string | null;
  referensi: string | null;

  npwppenerbit: string | null;
  tempatpenandatangan: string | null;
  npwpnikpenandatangan: string | null;

  created_by: string;
  updated_by: string | null;
  created_at: string;
  updated_at: string | null;

  errormsg: string | null;
};

export type TGetListDataDokumenLainMasukanResult = TGetListDataDokumenLainMasukan[];

export type TCountry = {
  kode: string;
  nama: string;
};

export type TCountryResult = TCountry[];

export type TGoods = {
  code: string;
  english: string;
  bahasa: string;
};

export type TGoodsResult = TGoods[];

export type TServices = {
  code: string;
  english: string;
  bahasa: string;
};

export type TServiceResult = TServices[];

export type TSatuan = {
  code: string;
  description: string;
};

export type TSatuanResult = TSatuan[];

export type TIdTambahan = {
  kode_awal: string;
  kode: string;
  deskripsi: string;
};

export type TIdTambahanResult = TIdTambahan[];

export type TKeteranganTambahan = {
  kode_awal: string;
  kode: string;
  deskripsi: string;
};

export type TKeteranganTambahanResult = TKeteranganTambahan[];

export type TPostDokumenLainMasukanRequest = {
  id: string;
  internal_id: string;

  isCreatedByBuyer: boolean;
  kdTransaksi: string;
  fgPengganti: string;

  nomorDokumenDiganti: string;
  detailTransaksi: string;
  keteranganTambahan: string;

  dokumenTransaksi: string;
  kodeDokumen: string;
  nomorDokumen: string;

  tanggalDokumen: string; // format: DDMMYYYY
  masaPajak: string;
  tahunPajak: string;

  referensi: string;

  jumlahDpp: number;
  jumlahPpn: number;
  jumlahPpnbm: number;

  objekFaktur: TObjekDokumenLainMasukanItem[];

  namaPenjual: string;
  npwpPenjual: string;
};

export type TObjekDokumenLainMasukanItem = {
  brgJasa: 'GOODS' | 'SERVICES';
  kdBrgJasa: string;
  namaBrgJasa: string;
  satuanBrgJasa: string;

  hargaSatuan: string; // API kirim string
  jmlBrgJasa: string;
  totalHarga: string;
  diskon: string;
  cekDppLain: boolean;

  dpp: string;
  tarifPpn: string;
  ppn: number;

  tarifPpnbm: string;
  ppnbm: string;
};

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TPostUpload = {
  id: string;
};

export type TDeleteRequest = {
  id: string;
};

export type TCancelRequest = {
  id: string | number;
  revokeFlag?: boolean; // format: DDMMYYYY
  tglPembatalan?: string;
  isCreatedByBuyer?: boolean;
};

export type TCancelResponse = TBaseResponseAPI<{
  id: string | number;
  statusBatal?: string;
  message?: string;
}>;

export type TReturDokumenMasukanRequest = {
  kdTransaksi: string;
  kdJenisTransaksi: string;
  jnsDok: string;

  nomorRetur: string;
  tanggalRetur: string; // format: DDMMYYYY
  nomorDokumenRetur: string;

  masaPajak: string;
  tahunPajak: string;

  npwpPenjual: string;
  namaPenjual: string;

  jumlahDppRetur: number;
  jumlahPpnRetur: number;
  jumlahPpnbmRetur: number;
};

export type TReturDokumenMasukanResponse = {
  status: boolean;
  message: string;
  data: unknown;
  code: number;
  time?: string;
  metaPage?: unknown;
  total?: number;
};

export interface TPrepopulatedDokumenLainMasukanRequest {
  masaPajak: string;
  tahunPajak: string;
}

export type TPostCreditUncreditedRequest = {
  id: number | string;
  statusPembeli: 'CREDITED' | 'UNCREDITED' | string;
};

export interface TRequestDokumenLainMasukanPrep {
  tahunPajak: string;
  masaPajak: string;
}
