import { useMutation } from '@tanstack/react-query';
import fakturApi from '../utils/api';
import type { TUploadReturPMRequest, TUploadReturPMResponse } from '../types/types';

const useUploadReturPM = (props?: any) =>
  useMutation<TUploadReturPMResponse, Error, TUploadReturPMRequest>({
    mutationKey: ['upload-retur-pm'],
    mutationFn: (payload) => fakturApi.uploadReturPM(payload),
    ...props,
  });

export default useUploadReturPM;
