import React from 'react';
import Chip from '@mui/material/Chip';
import Box from '@mui/material/Box';
import { HourglassTopRounded, AddTaskOutlined, TaskAltOutlined } from '@mui/icons-material';
import { IconButton, Tooltip } from '@mui/material';

type Props = {
  value?: string;
  revNo?: number;
  fgpelunasan?: string | boolean;
  fguangmuka?: string | boolean;
  fgpengganti?: string;
  credit?: string;
};

const StatusChip: React.FC<Props> = ({ value, fgpelunasan, fguangmuka, fgpengganti, credit }) => {
  if (!value) return <Chip label="" size="small" />;

  const componentCredit = (() => {
    if (credit === 'UNCREDITED') {
      return (
        <Chip
          label="UNCREDITED"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#d32f2f',
            color: '#d32f2f',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    } else if (credit === 'CREDITED') {
      return (
        <Chip
          label="CREDITED"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    } else if (credit === '') {
      return (
        <Chip
          label="Belum diKreditkan"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      );
    }

    return null;
  })();

  const extraComponent = (() => {
    if (fgpelunasan) {
      return (
        <Tooltip title="Pelunasan">
          <IconButton
            size="small"
            sx={{
              backgroundColor: 'blue',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: 'blue',
              },
            }}
          >
            <TaskAltOutlined style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      );
    }
    if (fguangmuka) {
      return (
        <Tooltip title="Uang Muka">
          <IconButton
            size="small"
            sx={{
              backgroundColor: 'green',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: 'green',
              },
            }}
          >
            <AddTaskOutlined style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      );
    }
    return null;
  })();

  let mainComponent: React.ReactNode = <Chip label={value} size="small" />;

  if (value === 'WAITING FOR AMENDMENT') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Normal Pengganti"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Tooltip title="Menunggu Persetujuan">
          <IconButton
            size="small"
            sx={{
              backgroundColor: 'orange',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: 'orange',
              },
            }}
          >
            <HourglassTopRounded style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      </Box>
    );
  } else if (value === 'APPROVED') {
    const isPengganti = fgpengganti === 'TD.00401';
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label={isPengganti ? 'Normal - Pengganti' : 'Normal'}
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#1976d2',
            color: '#1976d2',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Chip
          label="Approved"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#2e7d32',
            color: '#2e7d32',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
      </Box>
    );
  } else if (value === 'AMENDED') {
    mainComponent = (
      <Chip
        label="Diganti"
        size="small"
        variant="outlined"
        sx={{
          color: '#fff',
          backgroundColor: '#f38c28',
          borderRadius: '8px',
          fontWeight: 500,
          border: 'none',
          boxShadow: '0 1px 2px rgba(0, 0, 0, 0.15)',
        }}
      />
    );
  } else if (value === 'CANCELLED') {
    mainComponent = (
      <Chip
        label="Batal"
        size="small"
        variant="outlined"
        sx={{
          borderColor: '#d32f2f',
          color: '#d32f2f',
          borderRadius: '8px',
          fontWeight: 500,
        }}
      />
    );
  } else if (value === 'DRAFT') {
    mainComponent = (
      <Chip
        label="Draft"
        size="small"
        variant="outlined"
        sx={{
          borderColor: '#9e9e9e',
          color: '#616161',
          borderRadius: '8px',
        }}
      />
    );
  } else if (value === 'WAITING FOR CANCELLATION') {
    mainComponent = (
      <Box
        sx={{
          position: 'relative',
          display: 'inline-flex',
          alignItems: 'center',
          gap: '8px',
        }}
      >
        <Chip
          label="Batal"
          size="small"
          variant="outlined"
          sx={{
            borderColor: '#d32f2f',
            color: '#d32f2f',
            borderRadius: '8px',
            fontWeight: 500,
          }}
        />
        <Tooltip title="Menunggu Persetujuan">
          <IconButton
            size="small"
            sx={{
              backgroundColor: 'orange',
              color: 'white',
              '&:hover': {
                backgroundColor: 'white',
                color: 'orange',
              },
            }}
          >
            <HourglassTopRounded style={{ height: '15px', width: '15px' }} />
          </IconButton>
        </Tooltip>
      </Box>
    );
  }

  // ✅ Gabungkan komponen utama + tambahan
  return (
    <Box
      sx={{
        display: 'inline-flex',
        alignItems: 'center',
        gap: '8px',
      }}
    >
      {mainComponent}
      {componentCredit}
      {extraComponent}
    </Box>
  );
};

export default React.memo(StatusChip);
