export type TransaksiCode = 'DELIVERY' | 'EXPORT';

export interface TransaksiCodeOption {
  value: TransaksiCode;
  label: string;
}

export const TRANSAKSI_CODE_OPTIONS: TransaksiCodeOption[] = [
  { value: 'DELIVERY', label: 'DELIVERY' },
  { value: 'EXPORT', label: 'EXPORT' },
];

export const getTransaksiCodeLabel = (value?: string) =>
  TRANSAKSI_CODE_OPTIONS.find((opt) => opt.value === value)?.label ?? value;
